#include <SYS/TYPES.H>
#include <SPAD/LIBC.H>
#include <ARCH/CPU.H>
#include <KERNEL/CODEPAD.H>

#include <KERNEL/FEATURE.H>

unsigned FEATURE_FIND(feature_t box[_FEATURE_BOX_SIZE], feature_t feature)
{
	unsigned bottom = 1, top = box[0];
	while (bottom <= top) {
		unsigned middle = (top + bottom) / 2;
		if (box[middle] > feature) {
			top = middle - 1;
		} else if (box[middle] < feature) {
			bottom = middle + 1;
		} else return middle;
	}
	return 0;
}

__COLD_ATTR__ int FEATURE_FIXUP(struct feature_fixup *f, struct feature_fixup *end)
{
	while (f < end) {
		__f_off *p;
		unsigned long v;
		int valid;
		if (__unlikely(f->end2 - f->start2 > f->end1 - f->start1))
			KERNEL$SUICIDE("FEATURE_FIXUP: INVALID FIXUP RANGE: %lX-%lX %lX-%lX", (unsigned long)f->start1, (unsigned long)f->end1, (unsigned long)f->start2, (unsigned long)f->end2);
		p = &f->feature[0];
		valid = 1;
		do {
			v = *p++;
			if (__unlikely(v & FEATURE_PATCH_MODE & ~(FEATURE_VALUE | FEATURE_NEGATE | FEATURE_MORE)))
				return -EOPNOTSUPP;
			if (__unlikely(v & FEATURE_VALUE)) {
				if (FEATURE_FIND_VARIABLE(v & ~FEATURE_MORE, &f->start2, &f->end2))
					return -EOPNOTSUPP;
				if (__unlikely(f->end2 - f->start2 != f->end1 - f->start1))
					return -EINVAL;
			} else {
				valid &= (KERNEL$FEATURE_TEST(v & ~FEATURE_PATCH_MODE)) ^ ((v / FEATURE_NEGATE) & 1);
			}
		} while (__unlikely((v & FEATURE_MORE) != 0));
		if (valid) {
			__u8 *padptr;
			size_t padlen;
			memcpy((void *)f->start1, (void *)f->start2, f->end2 - f->start2);
			padptr = (__u8 *)(f->start1 + (f->end2 - f->start2));
			padlen = (f->end1 - f->start1) - (f->end2 - f->start2);
			CODE_PAD((unsigned long)padptr, padlen, padptr, padlen);
		}
		f = (struct feature_fixup *)p;
	}
	if (__unlikely(f > end))
		KERNEL$SUICIDE("FEATURE_FIXUP: RAN PAST THE END OF THE SECTION: %p > %p", f, end);
	return 0;
}
