#include <SPAD/LINK.H>
#include <ERRNO.H>

#include <KERNEL/FEATURE.H>

int FEATURE_FIND_VARIABLE(feature_t feature, __f_off *start, __f_off *end)
{
	static const __cpu_id_t cpu_id = 0;
	static const __cpu_id_t cpu_id_limit = 1;
	static const __node_id_t node_id = 0;
	static const __node_id_t node_id_limit = 1;
	switch (feature) {
		case FEATURE_VALUE_CPU_ID:
			*start = (__f_off)&cpu_id;
			*end = *start + sizeof(cpu_id);
			return 0;
		case FEATURE_VALUE_CPU_ID_LIMIT:
			*start = (__f_off)&cpu_id_limit;
			*end = *start + sizeof(cpu_id);
			return 0;
		case FEATURE_VALUE_NODE_ID:
			*start = (__f_off)&node_id;
			*end = *start + sizeof(node_id);
			return 0;
		case FEATURE_VALUE_NODE_ID_LIMIT:
			*start = (__f_off)&node_id_limit;
			*end = *start + sizeof(node_id);
			return 0;
		default:
			return -ENOENT;
	}
}

int FEATURE_USER_TEST(__u32 feature, int (*test)(__u32 feature))
{
	if (__unlikely(feature == FEATURE_USERSPACE)) return 1;
	return test(feature);
}

