#if put
#define mapflag		PF_WRITE
#else
#define mapflag		PF_READ
#endif

static int split(IOCTLRQ *rq, void *p)
{
	int spl;
	void *s;
	vspace_unmap_t *unmap;
	VDESC ov;
	memcpy(&ov, &rq->v, sizeof(VDESC));
	while (rq->v.len) {
		unsigned long ol = rq->v.len;
		if (((int)rq->v.ptr & (PAGE_CLUSTER_SIZE - 1)) + rq->v.len > PAGE_CLUSTER_SIZE)
			rq->v.len = PAGE_CLUSTER_SIZE - ((int)rq->v.ptr & (PAGE_CLUSTER_SIZE - 1));
		spl = KERNEL$SPL;
		RAISE_SPL(SPL_VSPACE);
		s = rq->v.vspace->op->vspace_map(&rq->v, mapflag, spl, &unmap);
		if (__unlikely(!s)) {
			memcpy(&rq->v, &ov, sizeof(VDESC));
			return 1;
		}
		if (__unlikely(__IS_ERR(s))) {
			memcpy(&rq->v, &ov, sizeof(VDESC));
			return __PTR_ERR(s);
		}
#if put
		memcpy(s, p, rq->v.len);
#else
		memcpy(p, s, rq->v.len);
#endif
		unmap(s);
		rq->v.ptr += rq->v.len;
		p = (char *)p + rq->v.len;
		rq->v.len = ol - rq->v.len;
	}
	memcpy(&rq->v, &ov, sizeof(VDESC));
	return 0;
}

int fn(IOCTLRQ *rq, void *p, long l)
{
	int spl;
	void *s;
	vspace_unmap_t *unmap;
#if __DEBUG >= 1
	if (!(IO_TYPE(rq->ioctl) & mapflag))
		KERNEL$SUICIDE("KERNEL$GETPUT_IOCTL_STRUCT: BAD ACCESS, IOCTL %X, WANT MASK %X", rq->ioctl, mapflag);
#endif
	if (__unlikely(l != rq->v.len)) {
		return -EINVAL;
	}
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_VSPACE);
	s = rq->v.vspace->op->vspace_map(&rq->v, mapflag, spl, &unmap);
	if (__unlikely(!s) && __likely(rq->v.len != 0)) {
		return 1;
	}
	if (__unlikely(__IS_ERR(s))) {
		if (__unlikely(__PTR_ERR(s) == -EINVAL))
			return split(rq, p);
		return __PTR_ERR(s);
	}
#if put
	memcpy(s, p, rq->v.len);
#else
	memcpy(p, s, rq->v.len);
#endif
	unmap(s);
	return 0;
}

#undef split
#undef fn
#undef put
#undef mapflag
