#include <SPAD/LIBC.H>
#include <KERNEL/THREAD.H>
#include <KERNEL/DEV.H>
#include <SPAD/DL.H>
#include <KERNEL/ASM.H>
#include <SPAD/SHELL.H>
#include <SPAD/VM.H>
#include <SPAD/SYNC.H>
#include <KERNEL/VM.H>
#include <KERNEL/MFS.H>
#include <KERNEL/PROC.H>
#include <KERNEL/ENV.H>
#include <KERNEL/PARAMS.H>
#include <KERNEL/SYSLOG.H>
#include <STRING.H>

static AST_STUB INIT_CONFIG_EXECUTED;
static AST_STUB INIT_KERNEL_DONE;

void INIT_KERNEL(void);

static long INIT_KERNEL_THREAD(void *p);

void INIT_KERNEL(void)
{
	static THREAD_RQ init_thread;
	BOUNCE_INIT();
	ENV_INIT();
	THREAD_INIT();
	CACHE_INIT();
	DEV_INIT();
	PARAMS_INIT();
	init_thread.fn = INIT_KERNEL_DONE;
	init_thread.thread_main = INIT_KERNEL_THREAD;
	init_thread.p = NULL;
	init_thread.error = NULL;
	init_thread.cwd = NULL;
	init_thread.std_in = -1;
	init_thread.std_out = -1;
	init_thread.std_err = -1;
	init_thread.dlrq = NULL;
	init_thread.thread = NULL;
	init_thread.spawned = 0;
	CALL_IORQ(&init_thread, KERNEL$THREAD);
}

static CTX *ctx;
static SHRCRQ shrcrq;

static long INIT_KERNEL_THREAD(void *p)
{
	union {
		DLLZRQ dl;
		SHCCRQ shccrq;
	} u;

	KERNEL_VM_INIT_2();

	MFS_INIT();

	KERNEL_PROC_INIT();

	u.dl.handle = __DL_GET_KERNEL_HANDLE();
	u.dl.caller = NULL;
	strcpy(u.dl.modname, "SHELL");
	SYNC_IO(&u.dl, KERNEL$DL_LOAD_LAZY);
	if (u.dl.status) {
		__critical_printf("UNABLE TO LOAD SHELL: %s\n", u.dl.error);
		HALT_KERNEL();
	}
	log_write_enable();
	SYNC_IO(&u.shccrq, SHELL$CREATE_CONTEXT);
	if (__unlikely(u.shccrq.status < 0)) {
		__critical_printf("UNABLE TO ALLOCATE SHELL CONTEXT: %s\n", strerror(-u.shccrq.status));
		HALT_KERNEL();
	}
	ctx = u.shccrq.ctx;
	SHELL$SET_TTY(ctx, SHELL_CONSOLE_OUTPUT, SHELL_CONSOLE_OUTPUT, SHELL_CONSOLE_OUTPUT, 0, 0, 0, 0);
	shrcrq.fn = &INIT_CONFIG_EXECUTED;
	shrcrq.ctx = ctx;
	shrcrq.ptr = "CALL MFS:/CONFIG.SYS";
	shrcrq.len = strlen(shrcrq.ptr);
	shrcrq.narg = 0;
	shrcrq.arg = NULL;
	CALL_IORQ(&shrcrq, SHELL$RUN_COMMANDS);

	return 0;
}

static DECL_AST(INIT_CONFIG_EXECUTED, SPL_DEV, SHRCRQ)
{
	if (RQ->status < 0)
		__critical_printf("SHELL FINISHED WITH EXIT CODE %ld%s%s\n", RQ->status, *RQ->error_msg ? ": " : "", RQ->error_msg);
	SHELL$DESTROY_CONTEXT(RQ->ctx);
	RETURN;
}

static DECL_AST(INIT_KERNEL_DONE, SPL_DEV, THREAD_RQ)
{
	if (RQ->status < 0) {
		if (!RQ->spawned)
			__critical_printf("COULD NOT SPAWN INIT THREAD: %s\n", strerror(-RQ->status));
		else
			__critical_printf("INIT THREAD RETURNED ERROR: %s\n", strerror(-RQ->status));
		HALT_KERNEL();
	}
	RETURN;
}
