#include <SPAD/TIMER.H>
#include <SPAD/LIST.H>
#include <KERNEL/ASM.H>

#include <ARCH/IO.H>

static const io_t iodelay_ports[] = { 0xed, 0x80 };

#define N_IODELAY_PORTS	(sizeof(iodelay_ports) / sizeof(*iodelay_ports))

static io_t iodelay_port = 0xed;

void KERNEL$SLOWDOWN_IO(void)
{
	if (__likely(iodelay_port != 0)) io_outb(iodelay_port, 0);
	else KERNEL$UDELAY(2);
}

	/* !!! SMPFIX: use some spinlock here */
static DECL_LIST(ports);

static void GET_NEW_IODELAY(void)
{
	IO_RANGE *pp;
	int i;
	for (i = 0; i < N_IODELAY_PORTS; i++) {
		LIST_FOR_EACH(pp, &ports, IO_RANGE, list) {
			if (__unlikely(iodelay_ports[i] >= pp->start)
			 && __unlikely(iodelay_ports[i] < pp->start + pp->len)) {
				goto collision;
			}
		}
		iodelay_port = iodelay_ports[i];
		return;
		collision:;
	}
	iodelay_port = 0;
}

int KERNEL$REGISTER_IO_RANGE(IO_RANGE *p)
{
	IO_RANGE *pp;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ALMOST_TOP), spl)))
		KERNEL$SUICIDE("KERNEL$REGISTER_IO_RANGE AT SPL %08X", spl);
	RAISE_SPL(SPL_ALMOST_TOP);
	LIST_FOR_EACH(pp, &ports, IO_RANGE, list) {
		if (__unlikely(pp == p))
			KERNEL$SUICIDE("KERNEL$REGISTER_IO_RANGE: REGISTERING RANGE "IO_FORMAT" - "IO_FORMAT" TWICE", p->start, p->start + p->len - 1);
		if (__unlikely(pp->start >= p->start + p->len)) break;
		if (__likely(pp->start + pp->len <= p->start)) continue;
		LOWER_SPLX(spl);
		return -EBUSY;
	}
	ADD_TO_LIST_BEFORE(&pp->list, &p->list);
	if (__unlikely(iodelay_port >= p->start)
	 && __unlikely(iodelay_port < p->start + p->len)) {
		GET_NEW_IODELAY();
	}
	LOWER_SPLX(spl);
	return 0;
}

void KERNEL$UNREGISTER_IO_RANGE(IO_RANGE *p)
{
	IO_RANGE *pp;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_ALMOST_TOP), spl)))
		KERNEL$SUICIDE("KERNEL$UNREGISTER_IO_RANGE AT SPL %08X", spl);
	RAISE_SPL(SPL_ALMOST_TOP);
	LIST_FOR_EACH(pp, &ports, IO_RANGE, list) if (pp == p) goto found;
	KERNEL$SUICIDE("KERNEL$UNREGISTER_IO_RANGE: UNREGISTERING NON-REGISTERED RANGE "IO_FORMAT" - "IO_FORMAT"", p->start, p->start + p->len - 1);
	found:
	DEL_FROM_LIST(&p->list);
	if (__unlikely(!iodelay_port)) {
		GET_NEW_IODELAY();
	}
	LOWER_SPLX(spl);
}

