#ifndef __KERNEL_IRQ_H
#define __KERNEL_IRQ_H

#include <ARCH/AC.H>
#include <ARCH/IRQ.H>
#include <ARCH/SETUP.H>

IRQ_HANDLE *KERNEL_MASK_IRQ_DI(IRQ_HANDLE *irq);

struct irq_controller {
	int n_irqs;
	IRQ_HANDLE *(*irq_get_handle)(int irq);
	void (*irq_request_rt)(int irq, IRQ_STUB *call, void *data);
	void (*irq_request_ast)(int irq, AST *ast);
	void (*irq_startup)(int irq);
	void (*irq_shutdown)(int irq, int masked);
	void (*di_hw)(void);
	void (*ei_hw)(void);
#if __KERNEL_SUPPORT_SMP
	void (*ipi_request)(int ipi, IRQ_STUB *call, unsigned data);
#endif
};

extern struct irq_controller IRQC;

void IRQ_INIT(void);

extern volatile unsigned long INTR_COUNT;

#endif
