#include <SPAD/LIBC.H>
#include <UNISTD.H>
#include <STRING.H>
#include <KERNEL/CONSOLE.H>
#include <KERNEL/ASM.H>
#include <ARCH/IO.H>
#include <SYS/UTSNAME.H>
#include <KERNEL/RELEASE.H>
#include <ARCH/ID.H>
#include <SPAD/CONSOLE.H>

int errno;

const char *__progname = "KERNEL";

static void cp_call(void *x, const char *data, int len)
{
	CONSOLE_WRITE(data, len);
}

int __critical_printf(const char *fmt, ...)
{
	int i;
	va_list args;
	va_start(args, fmt);
	KERNEL$CONSOLE_LOCK();
	i = __vxprintf(cp_call, NULL, fmt, args);
	KERNEL$CONSOLE_UNLOCK();
	va_end(args);
	return i;
}

int __critical_vprintf(const char *fmt, va_list args)
{
	int r;
	KERNEL$CONSOLE_LOCK();
	r = __vxprintf(cp_call, NULL, fmt, args);
	KERNEL$CONSOLE_UNLOCK();
	return r;
}

int (* volatile KERNEL$SUICIDE_DUMP)(void) = NULL;
void * volatile KERNEL$SUICIDE_DUMP_PARAM = NULL;

void KERNEL$SUICIDE(const char *fmt, ...)
{
	va_list args;
	va_start(args, fmt);
	KERNEL$DI();
	PREPARE_FOR_CRASH();
	KERNEL$CONSOLE_LOCK();
	__critical_printf("SYSTEM SUICIDE");
	if (FEATURE_TEST(FEATURE_SMP)) __critical_printf(" ON CPU %X", (unsigned)VAL_CPU_ID);
	__critical_printf(": ");
	__vxprintf(cp_call, NULL, fmt, args);
	__critical_printf("\n");
	KERNEL$CONSOLE_UNLOCK();
	HALT_KERNEL_STKDUMP();
}

void _exit_msg(int status, const char *msg)
{
	KERNEL$SUICIDE("KERNEL ATTEMPTED TO EXIT, STATUS %d%s%s", status, msg ? ", " : "", msg ? msg : "");
}

void _exit(int status)
{
	_exit_msg(status, NULL);
}

void _stop(char *msg)
{
	KERNEL$SUICIDE("KERNEL ATTEMPTED TO STOP%s%s", msg && *msg ? ": " : "", msg ? msg : "");
}

void _background(char *msg)
{
}

void (*__exit_func)(int status);

int uname(struct utsname *buf)
{
	char *e;
	memset(buf, 0, sizeof(struct utsname));
	strlcpy(buf->sysname, "SPAD", SYS_NMLN);
	if (!(e = getenv("HOSTNAME"))) e = "";
	strlcpy(buf->nodename, e, SYS_NMLN);
	strlcpy(buf->release, SPAD_RELEASE, SYS_NMLN);
	strlcpy(buf->version, SPAD_VERSION, SYS_NMLN);
	strlcpy(buf->machine, ARCH_ID, SYS_NMLN);
	if (!(e = getenv("DOMAINNAME"))) e = "";
	strlcpy(buf->domainname, e, SYS_NMLN);
	return 0;
}

