#ifndef __KERNEL_KSPAWN_H
#define __KERNEL_KSPAWN_H

#include <SPAD/AC.H>
#include <KERNEL/DEV.H>
#include <SPAD/PROC.H>

typedef struct {
	IORQ_HEAD;
	char jobname[9];
	LNT *lnt;
	int ln_mode;
	FFILE **forktable;
	int forktable_n;
	char **options;
	int n_options;
	char error[__MAX_STR_LEN];
	void *proc;		/* used internally */
	void *pcb;		/* not used by kernel */
} KSPAWNRQ;

extern IO_STUB KERNEL_KSPAWN;

int KERNEL_FORK(KSPAWNRQ *rq);

void DO_BREAK(PROC *r, KSPAWNRQ *rq, unsigned recursive);

#endif
