#include <ERRNO.H>
#include <SYS/MMAN.H>
#include <FCNTL.H>
#include <UNISTD.H>
#include <SIGNAL.H>
#include <LIB/KERNEL/USIGNAL.H>
#include <SYS/TIME.H>
#include <KERNEL/SYSCALL.H>
#include <KERNEL/KSPAWN.H>
#include <KERNEL/VM.H>
#include <KERNEL/DEV.H>
#include <LIB/KERNEL/UTHREAD.H>
#include <KERNEL/TIMER.H>
#include <KERNEL/RANDOM.H>
#include <KERNEL/SLAB.H>
#include <LIB/KERNEL/UIO.H>
#include <LIB/KERNEL/ULIBC.H>
#include <SPAD/LIST.H>
#include <SYS/IPC.H>
#include <SYS/SHM.H>
#include <SEMAPHORE.H>
#include <SPAD/THREAD.H>
#include <ARCH/LDT.H>
#include <PTY.H>

XLIST_HEAD environ_list;
XLIST_HEAD environ_callbacks;

LIST_HEAD all_slabs;
int n_slabs;
struct __slhead MALLOC_BUCKETS[N_MALLOC_BUCKETS] __ALIGN_ATTR__(__CPU_CACHELINE_ALIGN);

int __isthreaded = 1;

int KERNEL$__NEEDCANCEL = 0;
void (*KERNEL$__CANCEL_START_FN)(void) = NULL;
void (*KERNEL$__CANCEL_END_FN)(void) = NULL;
void (*KERNEL$__CANCEL_TEST_FN)(void) = NULL;

int __keep_open_files;

void *mmap(void *start, size_t length, int prot, int flags, int h, off_t offset)
{
	if ((flags | prot) & _MAP_IMMEDIATE) {
		return __ERR_PTR(-EKERNEL);
	} else {
		errno = EKERNEL;
		return MAP_FAILED;
	}
}

int munmap(void *start, size_t length)
{
	if (KERNEL$SPL == SPL_X(SPL_ZERO)) errno = EKERNEL;
	return -1;
}

int mprotect(void *start, size_t length, int prot)
{
	if (prot & _MAP_IMMEDIATE) {
		return -EKERNEL;
	} else {
		errno = EKERNEL;
		return -1;
	}
}

int msync(void *start, size_t length, int flags)
{
	errno = EKERNEL;
	return -1;
}

int _merror(void *start, size_t length)
{
	return 0;
}

USER_SIZE_DESC *USER_SIZE_DESCS = NULL;

void *MAKE_USER_SIZES(size_t s)
{
	return __ERR_PTR(-ENOMEM);
}

int brk(void *end)
{
	errno = EKERNEL;
	return -1;
}

void *sbrk(ssize_t inc)
{
	errno = EKERNEL;
	return (void *)-1;
}

int fcntl(int h, int op, ...)
{
	errno = EKERNEL;
	return -1;
}

int dup(int h)
{
	errno = EKERNEL;
	return -1;
}

int dup2(int h, int to)
{
	errno = EKERNEL;
	return -1;
}

int sigaction(int signum, const struct sigaction *act, struct sigaction *oldact)
{
	if (oldact) {
		oldact->sa_handler = SIG_DFL;
		sigemptyset(&oldact->sa_mask);
		oldact->sa_flags = 0;
	}
	return 0;
}

__sighandler_t signal(int signum, __sighandler_t handler)
{
	return SIG_DFL;
}

int sigprocmask(int how, const sigset_t *set, sigset_t *oldset)
{
	if (oldset) sigemptyset(oldset);
	return 0;
}

int sigpending(sigset_t *set)
{
	sigemptyset(set);
	return 0;
}

int raise(int sig)
{
	errno = EKERNEL;
	return -1;
}

int _thread_raise(int sig)
{
	errno = EKERNEL;
	return -1;
}

void raise_sighup(void)
{
}

int sigsuspend(const sigset_t *mask)
{
	errno = EKERNEL;
	return -1;
}

int sigwait(const sigset_t *set, int *sig)
{
	errno = EKERNEL;
	return -1;
}

void _thread_sigwait(const sigset_t *__set)
{
}

int sigaltstack(const stack_t *ss, stack_t *oss)
{
	if (oss) {
		oss->ss_sp = NULL;
		oss->ss_flags = SS_DISABLE;
		oss->ss_size = 0;
	}
	if (ss) {
		if (!(ss->ss_flags & SS_DISABLE)) {
			errno = EKERNEL;
			return -1;
		}
	}
	return 0;
}

int siginterrupt(int sig, int flag)
{
	return 0;
}

int SIGCHLD_FOR_STOPPED(void)
{
	return 0;
}

void KERNEL$INTR_SYSCALL(void)
{
}

int setitimer(int which, const struct itimerval *value, struct itimerval *ovalue)
{
	errno = EKERNEL;
	return -1;
}

int getitimer(int which, struct itimerval *t)
{
	errno = EKERNEL;
	return -1;
}

int execve(const char *path, char *const argv[], char *const envp[])
{
	errno = EKERNEL;
	return -1;
}

int modify_ldt(int fn, void *ptr, unsigned long n)
{
	errno = EKERNEL;
	return -1;
}

unsigned long SYSCALL1(unsigned long arg1)
{
	KERNEL$SUICIDE("SYSCALL1 CALLED (%lX)", arg1);
}

unsigned long SYSCALL2(unsigned long arg1, unsigned long arg2)
{
	KERNEL$SUICIDE("SYSCALL2 CALLED (%lX, %lX)", arg1, arg2);
}

unsigned long SYSCALL3(unsigned long arg1, unsigned long arg2, unsigned long arg3)
{
	KERNEL$SUICIDE("SYSCALL3 CALLED (%lX, %lX, %lX)", arg1, arg2, arg3);
}

int KERNEL_FORK(KSPAWNRQ *rq)
{
	KERNEL$SUICIDE("KERNEL_FORK CALLED");
}

void SIGNAL_FORK(void)
{
	KERNEL$SUICIDE("SIGNAL_FORK CALLED");
}

void SIGNAL_FORK_INTR_KEYS(void)
{
	KERNEL$SUICIDE("SIGNAL_FORK_INTR_KEYS CALLED");
}

void INSTALL_INTR_KEY(int h, int key, int signal)
{
}

int CANCEL_INTR_KEYS(int h, IORQ *rq)
{
	return !rq;
}

void REFRESH_INTR_KEYS(int h)
{
}

void THREAD_FORK(void)
{
	KERNEL$SUICIDE("THREAD_FORK CALLED");
}

int TIMER_DISABLE(void)
{
	KERNEL$SUICIDE("TIMER_DISABLE CALLED");
}

void TIMER_ENABLE(int state)
{
	KERNEL$SUICIDE("TIMER_ENABLE CALLED");
}

void TIMER_FORK(void)
{
	KERNEL$SUICIDE("TIMER_FORK CALLED");
}

int UIO_MAKE_FORKTABLE(FFILE ***forktable, int *forktable_n)
{
	KERNEL$SUICIDE("UIO_MAKE_FORKTABLE CALLED");
}

void UIO_FREE_FORKTABLE(FFILE **forktable, int forktable_n)
{
	if (__unlikely(forktable != NULL) || __unlikely(forktable_n))
		KERNEL$SUICIDE("UIO_FREE_FORKTABLE CALLED WITH NONEMPTY FORKTABLE (%p,%d)", forktable, forktable_n);
}

void UIO_FORK(void)
{
	KERNEL$SUICIDE("UIO_FORK CALLED");
}

void ULIBC_FORK(void)
{
	KERNEL$SUICIDE("ULIBC_FORK CALLED");
}

off_t lseek(int h, off_t offset, int whence)
{
	return slow_lseek(h, offset, whence);
}

int shmget(key_t key, size_t size, int flags)
{
	errno = EKERNEL;
	return -1;
}

void *shmat(int id, const void *addr, int flags)
{
	errno = EKERNEL;
	return (void *)-1L;
}

int shmdt(const void *addr)
{
	errno = EKERNEL;
	return -1;
}

int shmctl(int id, int cmd, struct shmid_ds *buf)
{
	errno = EKERNEL;
	return -1;
}

key_t ftok(const char *path, int id)
{
	errno = EKERNEL;
	return (key_t)-1;
}

int sem_init(sem_t *sem, int pshared, unsigned value)
{
	errno = EKERNEL;
	return -1;
}

int sem_destroy(sem_t *sem)
{
	errno = EKERNEL;
	return -1;
}

int sem_getvalue(sem_t *sem, int *sval)
{
	errno = EKERNEL;
	return -1;
}

int sem_post(sem_t *sem)
{
	errno = EKERNEL;
	return -1;
}

int sem_wait(sem_t *sem)
{
	errno = EKERNEL;
	return -1;
}

int sem_trywait(sem_t *sem)
{
	errno = EKERNEL;
	return -1;
}

int sem_timedwait(sem_t *sem, const struct timespec *abs_timeout)
{
	errno = EKERNEL;
	return -1;
}


void KERNEL$CALL_IN_THREAD(THREAD_RQ *rq, void (*fn)(void *, unsigned), void *data, unsigned data2)
{
	KERNEL$SUICIDE("KERNEL$CALL_IN_THREAD CALLED");
}

void urandom_add_data(RANDOM_CTX *ctx, void *ptr, int len)
{
	KERNEL$SUICIDE("urandom_add_data CALLED");
}

void USR_SWAP_ALL_HANDLES(void)
{
}

int openpty(int *amaster, int *aslave, char *name, struct termios *termi, struct winsize *wins)
{
	errno = EKERNEL;
	return -1;
}

int login_tty(int h)
{
	errno = EKERNEL;
	return -1;
}

pid_t forkpty(int *amaster, char *name, struct termios *termi, struct winsize *wins)
{
	errno = EKERNEL;
	return -1;
}

void drain_pty(void)
{
}
