#include <SPAD/LIST.H>
#include <SYS/TYPES.H>
#include <KERNEL/UDATADEF.H>
#include <SPAD/DL.H>
#include <SIGNAL.H>
#include <SPAD/SYNC.H>
#include <UNISTD.H>
#include <KERNEL/DIV64.H>
#include <STDARG.H>

#include <SPAD/LIBC.H>
#include <STDLIB.H>
#include <LIMITS.H>
#include <STRING.H>

/*
 * KISS random number generator (C) George Marsaglia
 */

/*
 *  linux/lib/vsprintf.c
 *
 *  Copyright (C) 1991, 1992  Linus Torvalds
 */

/* vsprintf.c -- Lars Wirzenius & Linus Torvalds. */
/*
 * Wirzenius wrote this portably, Torvalds fucked it up :-)
 */

static __finline__ int k_isdigit(char c) { return c >= '0' && c <= '9'; }

static int skip_atoi(const char **s)
{
	int i=0;

	while (k_isdigit(**s))
		i = i*10 + *((*s)++) - '0';
	return i;
}

#define ZEROPAD	1		/* pad with zero */
#define SIGN	2		/* unsigned/signed long */
#define PLUS	4		/* show plus */
#define SPACE	8		/* space if plus */
#define LEFT	16		/* left justified */
#define SPECIAL	32		/* 0x */
#define LARGE	64		/* use 'ABCDEF' instead of 'abcdef' */

#define VXP_BUF	64

#define PUTCHR(c) do { written++; buffer[(*bufptr)++] = c; if (*bufptr == VXP_BUF) print(data, buffer, *bufptr), *bufptr = 0; } while (0)

#ifdef __LONG_LONG_SUPPORTED
#define long_long	long long
#else
#define long_long	__s64
#endif

static int number(void (*print)(void *data, const char *c, int l), char *data, char *buffer, int *bufptr, long_long num, int base, int size, int precision, int type)
{
	int written = 0;
	char c,sign,tmp[66];
	const char *digits = "0123456789abcdefx0123456789ABCDEFX";
	int i;

	if (type & LARGE)
		digits += 17;
	if (__unlikely(type & LEFT))
		type &= ~ZEROPAD;
	if (__unlikely(base < 2) || __unlikely(base > 16))
		KERNEL$SUICIDE("number: BASE %d", base);
	c = (__unlikely(type & ZEROPAD)) ? '0' : ' ';
	sign = 0;
	if (type & SIGN) {
		if (__unlikely(num < 0)) {
			sign = '-';
			num = -num;
			size--;
		} else if (__unlikely(type & PLUS)) {
			sign = '+';
			size--;
		} else if (__unlikely(type & SPACE)) {
			sign = ' ';
			size--;
		}
	}
	if (__unlikely(type & SPECIAL)) {
		if (__likely(base == 16))
			size -= 2;
		else if (__likely(base == 8))
			size--;
	}
	i = 0;
	if (__unlikely(num == 0))
		tmp[i++]='0';
	else while (num != 0)
		tmp[i++] = digits[_do_div(num,base)];
	if (__likely(i > precision))
		precision = i;
	size -= precision;
	if (__likely(!(type&(ZEROPAD+LEFT))))
		while(__unlikely(size-->0))
			PUTCHR(' ');
	if (__unlikely(sign))
		PUTCHR(sign);
	if (__unlikely(type & SPECIAL)) {
		if (__unlikely(base==8))
			PUTCHR('0');
		else if (__likely(base==16)) {
			PUTCHR('0');
			PUTCHR(digits[16]);
		}
	}
	if (__likely(!(type & LEFT)))
		while (__unlikely(size-- > 0))
			PUTCHR(c);
	while (__unlikely(i < precision--))
		PUTCHR('0');
	while (i-- > 0)
		PUTCHR(tmp[i]);
	while (__unlikely(size-- > 0))
		PUTCHR(' ');
	return written;
}

int __vxprintf(void (*print)(void *data, const char *c, int l), void *data, const char *fmt, va_list args)
{
	char buffer[VXP_BUF];
	int bp = 0;
	int * const bufptr = &bp;
	int written = 0;
	int len;
	long_long num;
	int i, base;
	const char *s;

	int flags;		/* flags to number() */

	int field_width;	/* width of output field */
	int precision;		/* min. # of digits for integers; max
				   number of chars for from string */
	int qualifier;		/* 'h', 'l', or 'L' for integer fields */
				/* 'z' support added 23/7/1999 S.H.    */
				/* 'z' changed to 'Z' --davidm 1/25/99 */

	
	for (; *fmt ; ++fmt) {
		if (__likely(*fmt != '%')) {
			PUTCHR(*fmt);
			continue;
		}
			
		/* process flags */
		flags = 0;
		repeat:

		++fmt;		/* this also skips first '%' */
		switch (*fmt) {
			case '-': flags |= LEFT; goto repeat;
			case '+': flags |= PLUS; goto repeat;
			case ' ': flags |= SPACE; goto repeat;
			case '#': flags |= SPECIAL; goto repeat;
			case '0': flags |= ZEROPAD; goto repeat;
		}
		
		/* get field width */
		field_width = -1;
		if (__unlikely(k_isdigit(*fmt)))
			field_width = skip_atoi(&fmt);
		else if (__unlikely(*fmt == '*')) {
			++fmt;
			/* it's the next argument */
			field_width = va_arg(args, int);
			if (__unlikely(field_width < 0)) {
				field_width = -field_width;
				flags |= LEFT;
			}
		}

		/* get the precision */
		precision = -1;
		if (__unlikely(*fmt == '.')) {
			++fmt;	
			if (__likely(k_isdigit(*fmt)))
				precision = skip_atoi(&fmt);
			else if (__likely(*fmt == '*')) {
				++fmt;
				/* it's the next argument */
				precision = va_arg(args, int);
			}
			if (__unlikely(precision < 0))
				precision = 0;
		}

		/* get the conversion qualifier */
		qualifier = -1;
		if (__unlikely(*fmt == 'h') || __unlikely(*fmt == 'l') || __unlikely(*fmt == 'L') || __unlikely(*fmt =='Z')) {
			qualifier = *fmt;
			++fmt;
			if (qualifier == 'l' && *fmt == 'l') qualifier = 'L', fmt++;
			if (qualifier == 'h' && *fmt == 'h') qualifier = 'H', fmt++;
		}

		/* default base */
		base = 10;

		switch (*fmt) {
		case 'c':
			if (__likely(!(flags & LEFT)))
				while (__unlikely(--field_width > 0))
					PUTCHR(' ');
			PUTCHR((unsigned char) va_arg(args, int));
			while (__unlikely(--field_width > 0))
				PUTCHR(' ');
			continue;

		case 's':
			s = va_arg(args, char *);
			if (__unlikely(!s))
				s = "<NULL>";

			len = strnlen(s, precision);

			if (__likely(!(flags & LEFT)))
				while (__unlikely(len < field_width--))
					PUTCHR(' ');
			for (i = 0; i < len; ++i)
				PUTCHR(*s++);
			while (__unlikely(len < field_width--))
				PUTCHR(' ');
			continue;

		case 'p':
			if (__likely(field_width == -1)) {
				field_width = 2*sizeof(void *);
				flags |= ZEROPAD;
			}
			flags |= LARGE;
			written += number(print, data, buffer, bufptr,
				(unsigned long) va_arg(args, void *), 16,
				field_width, precision, flags);
			continue;


		/* paranoid reasons...
		case 'n':
			if (qualifier == 'l') {
				long * ip = va_arg(args, long *);
				*ip = written;
			} else if (qualifier == 'Z') {
				size_t * ip = va_arg(args, size_t *);
				*ip = written;
			} else {
				int * ip = va_arg(args, int *);
				*ip = written;
			}
			continue;
		*/

		case '%':
			PUTCHR('%');
			continue;

		/* integer number formats - set up the flags and "break" */
		case 'o':
			base = 8;
			break;

		case 'X':
			flags |= LARGE;
		case 'x':
			base = 16;
			break;

		case 'd':
		case 'i':
			flags |= SIGN;
		case 'u':
			break;

		default:
			PUTCHR('%');
			if (*fmt)
				PUTCHR(*fmt);
			else
				--fmt;
			continue;
		}
		if (__unlikely(qualifier == 'L'))
			num = va_arg(args, long_long);
		else if (__unlikely(qualifier == 'l')) {
			num = va_arg(args, unsigned long);
			if (__likely(flags & SIGN))
				num = (long) num;
		} else if (__unlikely(qualifier == 'Z')) {
			num = va_arg(args, size_t);
		} else if (__unlikely(qualifier == 'h')) {
			num = (unsigned short) va_arg(args, int);
			if (__likely(flags & SIGN))
				num = (short) num;
		} else if (__unlikely(qualifier == 'H')) {
			num = (unsigned char) va_arg(args, int);
			if (__likely(flags & SIGN))
				num = (signed char) num;
		} else {
			num = va_arg(args, unsigned int);
			if (__likely(flags & SIGN))
				num = (int) num;
		}
		written += number(print, data, buffer, bufptr, num, base, field_width, precision, flags);
	}
	if (__likely(*bufptr)) print(data, buffer, *bufptr);
	return written;
}

struct vsn_data {
	char *s;
	size_t n;
};

static void vsn_call(void *p, const char *data, int len)
{
	struct vsn_data *v = p;
	while (len--) {
		if (__unlikely(!v->n)) break;
		v->n--;
		*v->s++ = *data++;
	}
}

int _vsnprintf(char *str, size_t n, const char *fmt, va_list args)
{
	struct vsn_data v;
	if (__unlikely(!n)) return -1;
	v.s = str;
	v.n = n;
	__vxprintf(vsn_call, &v, fmt, args);
	if (__likely(v.n != 0)) {
		*v.s = 0;
		return v.s - str;
	}
	v.s[-1] = 0;
	return -1;
}

int _snprintf(char *str, size_t n, const char *fmt, ...)
{
	int i;
	va_list args;
	va_start(args, fmt);
	i = _vsnprintf(str, n, fmt, args);
	va_end(args);
	return i;
}

__COLD_ATTR__ static void p_call(void *x, const char *data, int len)
{
	ssize_t s;
	if (__unlikely(*(int *)x == -1)) return;
	do {
		s = write(*(int *)x, data, len);
		if (__unlikely(s <= 0)) {
			*(int *)x = -1;
			return;
		}
		data += s;
	} while (__unlikely(len -= s));
}

__COLD_ATTR__ int _vfprintf(int h, const char *fmt, va_list args)
{
	int i = __vxprintf(p_call, &h, fmt, args);
	if (__unlikely(h == -1)) return -1;
	return i;
}

__COLD_ATTR__ int _fprintf(int h, const char *fmt, ...)
{
	int i;
	va_list args;
	va_start(args, fmt);
	i = _vfprintf(h, fmt, args);
	va_end(args);
	return i;
}

__COLD_ATTR__ int _vprintf(const char *fmt, va_list args)
{
	return _vfprintf(KERNEL$STDOUT(), fmt, args);
}

__COLD_ATTR__ int _printf(const char *fmt, ...)
{
	int i;
	va_list args;
	va_start(args, fmt);
	i = _vfprintf(KERNEL$STDOUT(), fmt, args);
	va_end(args);
	return i;
}

__COLD_ATTR__ int _veprintf(const char *fmt, va_list args)
{
	return _vfprintf(KERNEL$STDERR(), fmt, args);
}

__COLD_ATTR__ int _eprintf(const char *fmt, ...)
{
	int i;
	va_list args;
	va_start(args, fmt);
	i = _vfprintf(KERNEL$STDERR(), fmt, args);
	va_end(args);
	return i;
}

int __check_logical_name(char *name, int chg)
{
	char *e;
	e = name + strlen(name);
	if (__likely(e > name) && __unlikely(e[-1] == ':')) {
		if (chg) e[-1] = 0;
		e--;
	}
	if (__unlikely((unsigned long)e - (unsigned long)name - 1 >= __MAX_STR_LEN)) return 1;
	if (__unlikely(*name == '@')) return 1;
	if (__unlikely(e[-1] == '.')) return 1;
	do {
		e--;
		if (__unlikely(*e == ':') || __unlikely(*e == '/') || __unlikely(*e == '=')) return 1;
		if (chg && __unlikely(*e >= 'a') && __likely(*e < 'z')) *e -= 0x20;
	} while (e > name);
	return 0;
}

static char default_state[20] = { 17 };
static char *cstate = default_state;

/* KISS generator by George Marsaglia */

static __u32 z=362436069, w=521288629, jsr=123456789, jcong=380116160;
/* Any non-zero seeds will do */
#define znew ((z=36969*(z&65535)+(z>>16))<<16)
#define wnew ((w=18000*(w&65535)+(w>>16))&65535)
#define MWC (znew+wnew)
#define SHR3 (jsr ^= jsr<<17, jsr ^= jsr>>13, jsr ^= jsr<<5)
#define CONG (jcong=69069*jcong+1234567)
#define KISS ((MWC^CONG)+SHR3)

int rand(void)
{
	return random();
}

long random(void)
{
	if (__likely(*cstate >= 17)) {
		return KISS & RAND_MAX;
	} else if (*cstate >= 9) {
		return (CONG + SHR3) & RAND_MAX;
	} else {
		return CONG & RAND_MAX;
	}
}

void srand(unsigned int seed)
{
	srandom(seed);
}

void srandom(unsigned int seed)
{
	if (!seed) seed = 1;
	z = w = jsr = jcong = seed;
}

char *initstate(unsigned seed, char *state, size_t size)
{
	char *old;
	if (__unlikely(size < 5))
		KERNEL$SUICIDE("initstate: TOO SMALL SIZE %ld", (long)size);
	memset(state, size, 0);
	if (size > 17) size = 17;
	state[0] = size;
	old = setstate(state);
	srandom(seed);
	return old;
}

char *setstate(char *state)
{
	char *old;
	memcpy(cstate + 1, &jcong, 4);
	if (__likely(*cstate >= 9)) {
		memcpy(cstate + 5, &jsr, 4);
		if (__likely(*cstate >= 17)) {
			memcpy(cstate + 9, &z, 4);
			memcpy(cstate + 13, &w, 4);
		}
	}
	old = cstate;
	cstate = state;
	if (__unlikely((unsigned char)(*cstate - 5) > 17 - 5))
		KERNEL$SUICIDE("setstate: INVALID STATE, SIZE %d", (unsigned char)*cstate);
	memcpy(&jcong, cstate + 1, 4);
	if (__likely(*cstate >= 9)) {
		memcpy(&jsr, cstate + 5, 4);
		if (__likely(*cstate >= 17)) {
			memcpy(&z, cstate + 9, 4);
			memcpy(&w, cstate + 13, 4);
		}
	}
	return old;
}

#define fn __get_number
#define type long
#define utype unsigned long
#include "LIBCGETN.I"
#define fn __get_64_number
#define type __s64
#define utype __u64
#include "LIBCGETN.I"

#define name __name
#define type __type
#define min __min
#define max __max
#define p __p

static int proc_arg(const struct __param_table *p, void *var, const char *arg, const char *arg_end)
{
	int state = 0;
	switch (p->type) {
		long n;
		__s64 n64;
		char *str;
		const char *strp;
		int r;
		struct __param_custom *cust;
		case __PARAM_BOOL:
			if (__unlikely(arg != NULL)) return -1;
			/* fall through */
		case __PARAM_BOOL_X:
			if (__unlikely((p->max & ~p->min) != 0)) KERNEL$SUICIDE("proc_arg: BAD MASK(%lX)/MODIFIER(%lX)", p->min, p->max);
			*(int *)var = (*(int *)var & ~p->min) | p->max;
			return 0;
		case __PARAM_INT:
		case __PARAM_UNSIGNED_INT:
		case __PARAM_LONG:
		case __PARAM_UNSIGNED_LONG:
		case __PARAM_PTR:
			if (__unlikely(arg == NULL)) return -1;
			if (__unlikely(__get_number(arg, arg_end, p->type == __PARAM_INT || p->type == __PARAM_LONG, &n))) return -1;
			if (__likely((p->min | p->max) != 0)) {
				if (p->type == __PARAM_INT || p->type == __PARAM_LONG) {
					if (__unlikely(n < p->min) || __unlikely(n >= p->max)) return -1;
				} else {
					if (__unlikely((unsigned long)n < p->min) || __unlikely((unsigned long)n >= p->max)) return -1;
				}
			}
			if (p->type == __PARAM_INT || p->type == __PARAM_UNSIGNED_INT) *(int *)var = n;
			else if (__unlikely(p->type == __PARAM_PTR)) *(void **)var = (void *)n;
			else /*if (p->type == __PARAM_LONG || p->type == __PARAM_UNSIGNED_LONG)*/ *(long *)var = n;
			return 0;
		case __PARAM_INT64:
		case __PARAM_UNSIGNED_INT64:
			if (__unlikely(arg == NULL)) return -1;
			if (__unlikely(__get_64_number(arg, arg_end, p->type == __PARAM_INT64, &n64))) return -1;
			if (p->max) {
				if (p->type == __PARAM_INT64) {
					if (__unlikely(n64 < p->min)) return -1;
				} else {
					if (__unlikely((__u64)n64 < p->min)) return -1;
				}
			}
			*(__s64 *)var = n64;
			return 0;
		case __PARAM_STRING:
			if (__unlikely(arg == NULL)) return -1;
			n = strlen(arg);
			if (__unlikely(n < (unsigned long)p->min) || __unlikely(n >= (unsigned long)p->max)) return -1;
			*(const char **)var = arg;
			return 0;
		case __PARAM_NEWSTRING:
			if (__unlikely(arg == NULL)) return -1;
			n = arg_end - arg;
			if (__unlikely(n < (unsigned long)p->min) || __unlikely(n >= (unsigned long)p->max)) return -1;
			str = __sync_malloc(n + 1);
			if (__unlikely(!str)) return -1;
			*(char *)mempcpy(str, arg, n) = 0;
			free(*(char **)var);
			*(char **)var = str;
			return 0;
		case __PARAM_EXTD_ONE:
			state = __STATE_EXT_NOSEP;
		case __PARAM_EXTD:
			if (arg == arg_end)
				return 0;
			if (!*arg_end) {
				str = (char *)arg;
			} else {
				n = arg_end - arg;
				str = __sync_malloc(n + 1);
				if (__unlikely(!str)) return -1;
				*(char *)mempcpy(str, arg, n) = 0;
			}
			strp = str;
			r = __parse_extd_param(&strp, &state, (struct __param_table *)p->min, var, NULL, NULL, NULL, NULL);
			if (str != arg)
				free(str);
			return r;
		case __PARAM_CUSTOM:
			cust = var;
			return cust->__f(arg, arg_end, cust->__p);
		default:
			KERNEL$SUICIDE("proc_arg: ARG %s HAS BAD TYPE %d", p->name, p->type);
	}
}

#if __DEBUG >= 2
static void check_params(const struct __param_table *p, void * const *vars, int extd)
{
	for (; p->name; p++, vars++) {
		*(volatile char *)p->name;
		if (__unlikely(!*vars)) KERNEL$SUICIDE("check_params: ARG %s HAS NULL POINTER", p->name);
		switch (p->type) {
			case __PARAM_BOOL:
			case __PARAM_BOOL_X:
				if (__unlikely((p->max & ~p->min) != 0)) KERNEL$SUICIDE("check_params: BAD MASK(%lX)/MODIFIER(%lX) ON ARG %s", p->min, p->max, p->name);
			case __PARAM_INT:
				*(volatile int *)*vars;
				break;
			case __PARAM_UNSIGNED_INT:
				*(volatile unsigned int *)*vars;
				break;
			case __PARAM_LONG:
				*(volatile long *)*vars;
				break;
			case __PARAM_UNSIGNED_LONG:
				*(volatile unsigned int *)*vars;
				break;
			case __PARAM_PTR:
				*(void * volatile *)*vars;
				break;
			case __PARAM_INT64:
				*(volatile __s64 *)*vars;
				break;
			case __PARAM_UNSIGNED_INT64:
				*(volatile __u64 *)*vars;
				break;
			case __PARAM_STRING:
				if (extd) KERNEL$SUICIDE("check_params: __PARAM_STRING WITHIN EXTD NOT ALLOWED");
				*(char * volatile *)*vars;
				break;
			case __PARAM_NEWSTRING:
				*(char * volatile *)*vars;
				break;
			case __PARAM_EXTD:
				if (extd) KERNEL$SUICIDE("check_params: __PARAM_EXTD WITHIN EXTD NOT ALLOWED");
			case __PARAM_EXTD_ONE:
				check_params((struct __param_table *)p->min, (void * const *)*vars, 1);
				break;
			case __PARAM_CUSTOM:
				*(volatile struct __param_custom *)*vars;
				break;
			default:
				KERNEL$SUICIDE("check_params: ARG %s HAS BAD TYPE %d", p->name, p->type);
		}
	}
	if (__unlikely(*vars != NULL))
		KERNEL$SUICIDE("check_params: EXTRA VARIABLE POINTERS");
}
#else
static __finline__ void check_params(const struct __param_table *p, void * const *vars, int extd)
{
}
#endif


int __parse_extd_param(const char **arg, int *state, const struct __param_table *p, void * const *vars, const char **opt, const char **optend, const char **val, const char **valend)
{
	char sep = *state & __STATE_EXT_NOSEP ? 0 : ',';
	int proc;
	int i;
	const char *e, *ae;
	check_params(p, vars, 1);
	if (__unlikely(!*arg) || __unlikely(!**arg)) return 0;
	next_arg:
	for (e = *arg; *e && *e != sep && *e != '='; e++) ;
	if (*e == '=') for (ae = e + 1; *ae && *ae != sep; ae++) ;
	else ae = NULL;
	proc = 0;
	for (i = 0; p[i].name; i++) if (!__strcasexcmp(p[i].name, *arg, e)) {
		if (!ae ? __unlikely(proc_arg(&p[i], vars[i], NULL, NULL)) : __unlikely(proc_arg(&p[i], vars[i], e + 1, ae))) {
			err:
			if (opt) *opt = NULL;
			if (optend) *optend = NULL;
			if (val) *val = NULL;
			if (valend) *valend = NULL;
			goto ret_err;
		}
		proc = 1;
	}
	if (!ae) {
		int o = *state >> 8;
		for (i = 0; p[i].name; i++) if (!p[i].name[0] && !o--) {
			*state += 1 << 8;
			if (__unlikely(proc_arg(&p[i], vars[i], *arg, e))) goto err;
			proc = 1;
			break;
		}
	}
	if (__unlikely(!proc)) {
		if (opt) *opt = *arg;
		if (optend) *optend = e;
		if (val) *val = !ae ? NULL : e + 1;
		if (valend) *valend = !ae ? NULL : ae;
		ret_err:
		*arg = !ae ? e : ae;
		if (**arg) (*arg)++;
		return 1;
	}
	if (ae) e = ae;
	if (*e) {
		*arg = e + 1;
		goto next_arg;
	}
	return 0;
}

int __parse_params(const char * const **argv, int *state, const struct __param_table *p, void * const *vars, const char **opt, const char **optend, const char **val)
{
	int i;
	const char *a;
	check_params(p, vars, 0);
	if (!*state) {
		if (__unlikely(!*(*argv)++)) return 0;
		*state = __STATE_NOFIRST;
	}
	next:
	if (!(a = **argv)) return 0;
	nexta:
	if (a[0] != '/') {
		int o;
		n_opt:
		o = *state >> 8;
		for (i = 0; p[i].name; i++) if (!p[i].name[0] && !o--) {
			*state += 1 << 8;
			if (__unlikely(proc_arg(&p[i], vars[i], a, a ? a + strlen(a) : NULL))) goto err;
			nextv:
			(*argv)++;
			goto next;
		}
		ret_a:
		if (opt) *opt = NULL;
		if (optend) *optend = NULL;
		if (val) *val = a;
		(*argv)++;
		return 1;
	} else {
		int proc;
		const char *v, *o;
		if (__unlikely(*state & __STATE_NOOPT)) goto n_opt;
		o = ++a;
		while (*a && *a != '/' && *a != ':' && *a != '=') a++;
		if (__unlikely(o == a)) goto xarg;
		if (!*a || *a == '/') v = NULL;
		else v = a + 1;
		proc = 0;
		for (i = 0; p[i].name; i++) if (!__strcasexcmp(p[i].name, o, a)) {
			if (__unlikely(proc_arg(&p[i], vars[i], v, v ? v + strlen(v) : NULL))) goto err;
			proc = 1;
		}
		if (__likely(proc)) {
			procc:
			if (*a == '/') goto nexta;
			else goto nextv;
		}
		if (__unlikely(a == o + 1) && __unlikely(*o == '-')) {
			*state |= __STATE_NOOPT;
			goto procc;
		}
		if (__unlikely(!opt) || __unlikely(!optend) || __unlikely(*a == '/')) {
			xarg:
			if (o - 1 == **argv) {
				a = o - 1;
				goto n_opt;
			}
			err:
			a = NULL;
			goto ret_a;
		}
		*opt = o;
		*optend = a;
		if (__likely(val != NULL)) *val = v;
		else if (__unlikely(v != NULL)) goto err;
		(*argv)++;
		return 1;
	}
}

int __accumulate_params(char **param, const char *opt, const char *optend, const char *val, const char *valend)
{
	MALLOC_REQUEST mrq;
	size_t l;
	char *c;
	if ((val && __unlikely(memchr(val, ',', valend - val) != 0)) || __unlikely(memchr(opt, ',', optend - opt) != 0)) return -EBADSYN;
	l = *param ? strlen(*param) + 2 : 1;
	l += optend - opt;
	if (val) l += valend - val + 1;
	mrq.size = l;
	SYNC_IO_CANCELABLE(&mrq, KERNEL$UNIVERSAL_MALLOC);
	if (__unlikely(mrq.status < 0)) return mrq.status;
	if (*param) {
		c = stpcpy(stpcpy(mrq.ptr, *param), ",");
		free(*param);
		*param = mrq.ptr;
	} else {
		c = *param = mrq.ptr;
	}
	c = mempcpy(c, opt, optend - opt);
	if (val) {
		*c++ = '=';
		c = mempcpy(c, val, valend - val);
	}
	*c++ = 0;
	return 0;
}

__COLD_ATTR__ const char *__exceptionmsg(int except, void *ip, void *address, long error, int resolve_sym)
{
	static char xcptmsg[__MAX_STR_LEN];
	_snprintf(xcptmsg, __MAX_STR_LEN, "EXCEPTION %s AT %p", __strexception(except), ip);
	if (resolve_sym) {
		unsigned long off;
		const char *name = KERNEL$DL_GET_SYMBOL_NAME(ip, &off, 0);
		if (name) {
			_snprintf(xcptmsg + strlen(xcptmsg), __MAX_STR_LEN - strlen(xcptmsg), "<%s+%lX>", name, off);
		}
	}
	if (address || except == XCPT_RPF || except == XCPT_WPF) {
		_snprintf(xcptmsg + strlen(xcptmsg), __MAX_STR_LEN - strlen(xcptmsg), " (ADDRESS %p%s%s%s", address, error ? ", ERROR " : ")", error ? strerror(-error) : "", error ? ")" : "");
	} else {
		_snprintf(xcptmsg + strlen(xcptmsg), __MAX_STR_LEN - strlen(xcptmsg), "%s%s%s", error ? " (ERROR " : "", error ? strerror(-error) : "", error ? ")" : "");
	}
	return xcptmsg;
}


const char *const sys_siglist[] = {
	"NO SIGNAL",
	"HANGUP",
	"INTERRUPT",
	"QUIT",
	"ILLEGAL INSTRUCTION",
	"TRAP",
	"ABORT",
	"BUS ERROR",
	"FLOATING-POINT ERROR",
	"KILL",
	"USER SIGNAL 1",
	"SEGMENTATION FAULT",
	"USER SIGNAL 2",
	"BROKEN PIPE",
	"ALARM",
	"TERMINATE",
	"UNKNOWN SIGNAL 16",
	"CHILD EXIT",
	"CONTINUE",
	"STOP",
	"TERMINAL STOP",
	"TERMINAL INPUT",
	"TERMINAL OUTPUT",
	"URGENT DATA",
	"UNKNOWN SIGNAL 24",
	"UNKNOWN SIGNAL 25",
	"VIRTUAL ALARM",
	"PROFILE",
	"WINDOW RESIZE",
	"IO POSSIBLE",
	"UNKNOWN SIGNAL 30",
	"MACHINE CHECK EXCEPTION",
};

__COLD_ATTR__ char *strsignal(int signum)
{
	static char errmsg[__MAX_STR_LEN];
	if (__likely((unsigned)signum < sizeof(sys_siglist) / sizeof(const char *))) return (char *)sys_siglist[signum];
	_snprintf(errmsg, __MAX_STR_LEN, "UNKNOWN SIGNAL %d", signum);
	return errmsg;
}

const char *const sys_errlist[] = {
	"NO ERROR",
	NULL,
	"NOT FOUND",
	"NO SUCH JOB",
	"INTERRUPTED",
	"IO ERROR",
	"NO SUCH DEVICE OR ADDRESS",
	"ARG LIST TOO LONG",
	"FILE IS NOT AN EXECUTABLE",
	"BAD FILE HANDLE",
	"NO CHILD PROCESS",
	"TRY AGAIN",
	"OUT OF MEMORY",
	"ACCESS DENIED",
	"VM FAULT",
	"NOT BLOCK DEVICE",
	"BUSY",
	"ALREADY EXISTS",
	"CROSS-FILESYSTEM MOVE",
	"NO DEVICE",
	"NOT A DIRECTORY",
	"IS A DIRECTORY",
	"INVALID ARGUMENT",
	"SYSTEM FILE TABLE IS FULL",
	"TOO MANY OPEN FILES",
	"NOT A TERMINAL",
	"PROGRAM FILE BUSY",
	"FILE TOO BIG",
	"FILESYSTEM IS FULL",
	"ILLEGAL SEEK",
	"READ ONLY FILESYSTEM",
	"TOO MANY LINKS",
	"BROKEN PIPE",
	"MATH ARGUMENT OUT OF FUNCTION DOMAIN",
	"OUT OF RANGE",
	"DEADLOCK WOULD OCCUR",
	"NAME TOO LONG",
	"NO LOCKS AVAILABLE",
	"SYSCALL NOT IMPLEMENTED",
	"NOT EMPTY",
	"LOOP IN REFERENCES",
	NULL,
	"NO MESSAGE OF DESIRED TYPE",
	"IDENTIFIER REMOVED",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	"NOT A STREAM",
	"NO DATA AVAILABLE",
	"TIMER EXPIRED",
	"NO STREAM RESOURCES",
	NULL,
	NULL,
	NULL,
	"NO LINK",
	NULL,
	NULL,
	NULL,
	"PROTOCOL ERROR",
	"MULTIHOP ATTEMPTED",
	NULL,
	"BAD MESSAGE",
	"OVERFLOW",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	"ILLEGAL BYTE SEQUENCE",
	NULL,
	NULL,
	NULL,
	"SOCKET OPERATION ON NON-SOCKET",
	"DESTINATION ADDRESS REQUIRED",
	"MESSAGE TOO LONG",
	"WRONG PROTOCOL FOR SOCKET",
	"NO SUCH PROTOCOL OPTION",
	"PROTOCOL NOT SUPPORTED",
	NULL,
	"OPERATION NOT SUPPORTED",
	"PROTOCOL FAMILY NOT SUPPORTED",
	"ADDRESS FAMILY NOT SUPPORTED",
	"PORT IN USE",
	"LOCAL ADDRESS NOT AVAILABLE",
	"NETWORK IS DOWN",
	"NETWORK IS UNREACHABLE",
	"CONNECTION DROPPED BECAUSE OF RESET",
	"SOFTWARE CONNECTION ABORT",
	"CONNECTION RESET BY PEER",
	"OUT OF BUFFERS",
	"SOCKET IS ALREADY CONNECTED",
	"SOCKET IS NOT CONNECTED",
	"CONNECTION IS SHUT DOWN",
	NULL,
	"TIMEOUT",
	"CONNECTION REFUSED",
	"HOST IS DOWN",
	"HOST IS UNREACHABLE",
	"OPERATION ALREADY IN PROGRESS",
	"OPERATION IN PROGRESS",
	"STALE HANDLE",
	NULL,
	NULL,
	NULL,
	NULL,
	NULL,
	"QUOTA EXCEEDED",
	"NO MEDIUM IN DRIVE",
	NULL,
	NULL,
	NULL,
	NULL,
	"NO LOGICAL NAME",
	"SYNTAX ERROR",
	"INVALID OPERATION FOR THIS DEVICE",
	"NO CURRENT DIRECTORY",
	"BAD MODIFIER",
	"FILESYSTEM IS CORRUPTED",
	"UNEXPECTED END OF FILE",
	"INVALID VSPACE",
	"STOPPED",
	"TTY CHANGED",
	"BACKGROUND",
	"OPERATION NOT SUPPORTED IN USER MODE",
	"OPERATION NOT SUPPORTED IN KERNEL MODE",
	"INAPPROPRIATE FILE TYPE OR FORMAT",
	"VSPACE PAGE FAULT",
	NULL,
	"MEDIA IS WRITE PROTECTED",
	"OPERATION NOT PERMITTED",
};

static const struct {
	int code;
	char *name;
} error_names[] = {
	ENOENT, "ENOENT",
	ESRCH, "ESRCH",
	EINTR, "EINTR",
	EIO, "EIO",
	ENXIO, "ENXIO",
	E2BIG, "E2BIG",
	ENOEXEC, "ENOEXEC",
	EBADF, "EBADF",
	ECHILD, "ECHILD",
	EAGAIN, "EAGAIN",
	EWOULDBLOCK, "EWOULDBLOCK",
	ENOMEM, "ENOMEM",
	EACCES, "EACCES",
	EFAULT, "EFAULT",
	ENOTBLK, "ENOTBLK",
	EBUSY, "EBUSY",
	EEXIST, "EEXIST",
	EXDEV, "EXDEV",
	ENODEV, "ENODEV",
	ENOTDIR, "ENOTDIR",
	EISDIR, "EISDIR",
	EINVAL, "EINVAL",
	ENFILE, "ENFILE",
	EMFILE, "EMFILE",
	ENOTTY, "ENOTTY",
	ETXTBSY, "ETXTBSY",
	EFBIG, "EFBIG",
	ENOSPC, "ENOSPC",
	ESPIPE, "ESPIPE",
	EROFS, "EROFS",
	EMLINK, "EMLINK",
	EPIPE, "EPIPE",
	EDOM, "EDOM",
	ERANGE, "ERANGE",
	EDEADLK, "EDEADLK",
	EDEADLOCK, "EDEADLOCK",
	ENAMETOOLONG, "ENAMETOOLONG",
	ENOLCK, "ENOLCK",
	ENOSYS, "ENOSYS",
	ENOTEMPTY, "ENOTEMPTY",
	ELOOP, "ELOOP",
	ENOMSG, "ENOMSG",
	EIDRM, "EIDRM",
	ENOSTR, "ENOSTR",
	ENODATA, "ENODATA",
	ETIME, "ETIME",
	ENOSR, "ENOSR",
	ENOLINK, "ENOLINK",
	EPROTO, "EPROTO",
	EMULTIHOP, "EMULTIHOP",
	EBADMSG, "EBADMSG",
	EOVERFLOW, "EOVERFLOW",
	EILSEQ, "EILSEQ",
	ENOTSOCK, "ENOTSOCK",
	EDESTADDRREQ, "EDESTADDRREQ",
	EMSGSIZE, "EMSGSIZE",
	EPROTOTYPE, "EPROTOTYPE",
	ENOPROTOOPT, "ENOPROTOOPT",
	EPROTONOSUPPORT, "EPROTONOSUPPORT",
	EOPNOTSUPP, "EOPNOTSUPP",
	ENOTSUP, "ENOTSUP",
	EPFNOSUPPORT, "EPFNOSUPPORT",
	EAFNOSUPPORT, "EAFNOSUPPORT",
	EADDRINUSE, "EADDRINUSE",
	EADDRNOTAVAIL, "EADDRNOTAVAIL",
	ENETDOWN, "ENETDOWN",
	ENETUNREACH, "ENETUNREACH",
	ENETRESET, "ENETRESET",
	ECONNABORTED, "ECONNABORTED",
	ECONNRESET, "ECONNRESET",
	ENOBUFS, "ENOBUFS",
	EISCONN, "EISCONN",
	ENOTCONN, "ENOTCONN",
	ESHUTDOWN, "ESHUTDOWN",
	ETIMEDOUT, "ETIMEDOUT",
	ECONNREFUSED, "ECONNREFUSED",
	EHOSTDOWN, "EHOSTDOWN",
	EHOSTUNREACH, "EHOSTUNREACH",
	EALREADY, "EALREADY",
	EINPROGRESS, "EINPROGRESS",
	ESTALE, "ESTALE",
	EDQUOT, "EDQUOT",
	ENOMEDIUM, "ENOMEDIUM",
	ENOLNM, "ENOLNM",
	EBADSYN, "EBADSYN",
	ENOOP, "ENOOP",
	ENOCWD, "ENOCWD",
	EBADMOD, "EBADMOD",
	EFSERROR, "EFSERROR",
	EEOF, "EEOF",
	ENOVSPACE, "ENOVSPACE",
	ESTOPPED, "ESTOPPED",
	ETTYCHG, "ETTYCHG",
	EBACKGROUND, "EBACKGROUND",
	EUSER, "EUSER",
	EKERNEL, "EKERNEL",
	EFTYPE, "EFTYPE",
	EVSPACEFAULT, "EVSPACEFAULT",
	EWP, "EWP",
	EPERM, "EPERM",
};

const int sys_nerr = sizeof(sys_errlist) / sizeof(const char *);

char *strerror(int errnum)
{
	static char errmsg[__MAX_STR_LEN];
	if (__likely((unsigned)errnum < sizeof(sys_errlist) / sizeof(const char *)) && __likely(sys_errlist[errnum] != NULL))
		return (char *)sys_errlist[errnum];
	if (__likely(-errnum >= __EXIT_SIGNAL_VAL) && __likely(-errnum < __EXIT_SIGNAL_VAL + NSIG)) return strsignal(-errnum - __EXIT_SIGNAL_VAL);
	_snprintf(errmsg, __MAX_STR_LEN, "UNKNOWN ERROR %d", errnum);
	return errmsg;
}

int _err_code(const char *name)
{
	int i;
	for (i = 0; i < sizeof(error_names) / sizeof(*error_names); i++)
		if (__unlikely(!_strcasecmp(error_names[i].name, name)))
			return error_names[i].code;
	return -1;
}

