#include <SPAD/LINK.H>

int LINK_CHECK_HEADER(void *head, unsigned *header_size, unsigned *n_dependencies, unsigned *hash_method, unsigned *compression_method, unsigned long *compressed_file_size, char error[__MAX_STR_LEN])
{
	struct link_header *h = head;
	if (__unlikely(h->lnk_id != LNK_ID)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "FILE IS NOT AN EXECUTABLE");
		return -1;
	}
	if (__unlikely(h->lnk_ver != LNK_VER)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "BAD VERSION %d, EXPECTED %d", h->lnk_ver, LNK_VER);
		return -1;
	}
	if (__unlikely(h->mach_id != MACH_CURRENT)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "EXECUTABLE IS FOR DIFFERENT MACHINE");
		return -1;
	}
	if (__unlikely(h->n_sections < 5)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "NOT ALL SECTIONS (.HEAD, .TEXT, .RODATA, .DATA, .BSS) PRESENT");
		return -1;
	}
	if (__unlikely(h->compression_offset < sizeof(struct link_header))) {
		if (error) _snprintf(error, __MAX_STR_LEN, "TOO SHORT HEADER");
		return -1;
	}
	if (__unlikely(h->compression_offset >= 0x100000)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "TOO LONG HEADER");
		return -1;
	}
	*header_size = h->compression_offset;
	if (__unlikely(h->n_libs >= 0x100000)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "TOO MANY DEPENDENCIES");
		return -1;
	}
	*n_dependencies = h->n_libs;
	*hash_method = h->flags & LINK_HASH_MASK;
	*compression_method = h->flags & LINK_COMPRESSION_MASK;
	*compressed_file_size = h->compressed_file_size;
	return 0;
}

int LINK_GET_SECTIONS_SIZE(void *head, unsigned long *code_size, unsigned long *rodata_size, unsigned long *data_size, unsigned long *bss_size, char error[__MAX_STR_LEN])
{
	struct link_header *h = head;
	struct section *secs;
	if (__unlikely(LINK_CHECK_HEADER(head, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, (void *)&KERNEL$LIST_END, error))) {
		return -1;
	}
	secs = (struct section *)((char *)h + h->sections);
	if (__unlikely((char *)secs < (char *)h) || __unlikely((char *)&secs[5] > (char *)h + h->compression_offset)) {
		if (error) _snprintf(error, __MAX_STR_LEN, "SECTIONS OUT OF HEADER");
		return -1;
	}
/* note: the pointers may be KERNEL$LIST_END, so more assignments on one line are needed */
	*data_size = secs[3].offset + secs[3].len - (secs[2].offset + secs[2].len);
	*rodata_size = secs[2].offset + secs[2].len -
	(*code_size = secs[1].offset + secs[1].len);
	*bss_size = secs[4].len;
	return 0;
}
