#ifdef sio
#define WFN KERNEL$WAKE_READ
static DECL_IOCALL(mfs_read, SPL_FS, SIORQ)
#else
#define WFN KERNEL$WAKE_AREAD
static DECL_IOCALL(mfs_aread, SPL_FS, AIORQ)
#endif
{
	unsigned pos;
	char *pp;
	MFSFILE *f;
#ifdef sio
	FFILE *file;
	vspace_unmap_t *funmap;
#endif
	HANDLE *h = RQ->handle;
	if (__unlikely(h->op != &mfs_file_operations)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_FS));
	f = h->fnode;
#ifdef sio
	file = KERNEL$MAP_FILE_STRUCT(h, (IORQ *)RQ, &funmap);
	if (__unlikely(!file)) RETURN;
#endif

	if (__unlikely(!RQ->v.len)) goto eof;

	next_page:
#ifdef sio
	pos = file->pos;
#else
	pos = RQ->pos;
#endif
	if (pos >= f->size) goto eof;

	{
		long s;
		VBUF vbuf;
		int rsz;
		rsz = PAGE_CLUSTER_SIZE - (pos & (PAGE_CLUSTER_SIZE - 1));
		if (pos + rsz > f->size) rsz = f->size - pos;
		RAISE_SPL(SPL_VSPACE);
		pp = KERNEL$MAP_PHYSICAL_PAGE(find_page(f, pos));
		vbuf.ptr = pp + (pos & (PAGE_CLUSTER_SIZE - 1));
		vbuf.len = rsz;
		vbuf.spl = SPL_X(SPL_FS);
		s = RQ->v.vspace->op->vspace_put(&RQ->v, &vbuf);
		KERNEL$UNMAP_PHYSICAL_BANK(pp);
		if (__unlikely(!s)) goto pf;
		RQ->progress += s;
#ifdef sio
		file->pos += s;
#else
		RQ->pos += s;
#endif
	}
	SWITCH_PROC_ACCOUNT(RQ->handle->name_addrspace, SPL_X(SPL_FS));
#ifdef sio
	TEST_LOCKUP_LOOP(RQ, {
		funmap(file);
		RETURN;
	});
#else
	TEST_LOCKUP_LOOP(RQ, RETURN);
#endif
	if (RQ->v.len) goto next_page;

	eof:
#ifdef sio
	funmap(file);
#endif
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);

	pf:
#ifdef sio
	funmap(file);
#endif
	DO_PAGEIN(RQ, &RQ->v, PF_WRITE);
}

#undef WFN

#ifdef sio
#define WFN KERNEL$WAKE_WRITE
static DECL_IOCALL(mfs_write, SPL_FS, SIORQ)
#else
#define WFN KERNEL$WAKE_AWRITE
static DECL_IOCALL(mfs_awrite, SPL_FS, AIORQ)
#endif
{
	unsigned pos;
	char *pp;
	PAGE *p;
	MFSFILE *f;
	FFILE *file;
	vspace_unmap_t *funmap;
	WQ *wq;
	HANDLE *h = RQ->handle;
	if (__unlikely(h->op != &mfs_file_operations)) RETURN_IORQ_LSTAT(RQ, WFN);
	RQ->tmp1 = (unsigned long)WFN;
	TEST_LOCKUP_ENTRY(RQ, RETURN);
	SWITCH_PROC_ACCOUNT(h->name_addrspace, SPL_X(SPL_FS));
	f = h->fnode;
	file = KERNEL$MAP_FILE_STRUCT(h, (IORQ *)RQ, &funmap);
	if (__unlikely(!file)) RETURN;

	if (__unlikely(!RQ->v.len)) goto ret_succ;

	next_page:
	if (file->flags & O_APPEND) {
		pos = f->size;
	} else {
#ifdef sio
		pos = file->pos;
#else
		pos = RQ->pos;
#endif
	}
	if (__unlikely((wq = mfs_extend_file(f, pos, 1)) != NULL)) {
		if (__unlikely(__IS_ERR(wq))) {
			RQ->status = __PTR_ERR(wq);
			CALL_AST(RQ);
		} else {
			WQ_WAIT_F(wq, RQ);
		}
		unmap_return:
		funmap(file);
		RETURN;
	}
	p = find_page(f, pos);
	{
		long s;
		VBUF vbuf;
		int rsz;
		rsz = PAGE_CLUSTER_SIZE - (pos & (PAGE_CLUSTER_SIZE - 1));
		RAISE_SPL(SPL_VSPACE);
		pp = KERNEL$MAP_PHYSICAL_PAGE(p);
		vbuf.ptr = pp + (pos & (PAGE_CLUSTER_SIZE - 1));
		vbuf.len = rsz;
		vbuf.spl = SPL_X(SPL_FS);
		s = RQ->v.vspace->op->vspace_get(&RQ->v, &vbuf);
		KERNEL$UNMAP_PHYSICAL_BANK(pp);
		if (__unlikely(!s)) {
			if ((unsigned)p->id == f->size) {
				DEL_FROM_LIST(&p->hash_entry);
				KERNEL$FREE_USER_PAGE(p, VM_TYPE_WIRED_UNMAPPED);
			}
			goto pf;
		}
		RQ->progress += s;
		if (file->flags & O_APPEND) {
			f->size += s;
#ifdef sio
			file->pos = f->size;
#else
			RQ->pos = f->size;
#endif
		} else {
			pos += s;
#ifdef sio
			file->pos = pos;
#else
			RQ->pos = pos;
#endif
			if (__likely(pos > f->size)) f->size = pos;
		}
	}
	SWITCH_PROC_ACCOUNT(RQ->handle->name_addrspace, SPL_X(SPL_FS));
	TEST_LOCKUP_LOOP(RQ, goto unmap_return;);
	if (RQ->v.len) goto next_page;

	ret_succ:
	funmap(file);
	if (__likely(RQ->progress >= 0)) RQ->status = RQ->progress;
	else RQ->status = -EOVERFLOW;
	RETURN_AST(RQ);

	pf:
	funmap(file);
	DO_PAGEIN(RQ, &RQ->v, PF_READ);
}

#undef WFN

