#include <ARCH/AC.H>
#include <SPAD/LIBC.H>
#include <KERNEL/VM_ARCH.H>
#include <KERNEL/VM.H>
#include <SPAD/ENV.H>

#include <KERNEL/PARAMS.H>

#define STREAM_QUEUE_PCT	16
#define STREAM_REACTIVATE	32

#define STREAM_QUEUE_MIN	(4194304 / PAGE_CLUSTER_SIZE)
#define STREAM_QUEUE_MAX	(67108864 / PAGE_CLUSTER_SIZE)

static int getunsignedlong(char *v, unsigned long *var, int shift, unsigned long min, unsigned long max)
{
	unsigned long l;
	char *e = getenv(v);
	if (__likely(!e)) return 1;
	if (__unlikely(__get_number(e, strchr(e, 0), 0, (long *)&l))) return 1;
	l >>= shift;
	if (__unlikely(l < min)) return 1;
	if (__unlikely(l > max)) return 1;
	*var = l;
	return 0;
}

static int getunsigned(char *v, unsigned *var, int shift, unsigned min, unsigned max)
{
	unsigned long l;
	if (getunsignedlong(v, &l, shift, min, max)) return 1;
	*var = l;
	return 0;
}

static void REFRESH_PARAMS_CALLBACK(ENV_CALLBACK *e)
{
	REFRESH_PARAMS();
}

void REFRESH_PARAMS(void)
{
	unsigned long kz, iz, hz;
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), spl))) KERNEL$SUICIDE("REFRESH_PARAMS AT SPL %08X", spl);
	RAISE_SPL(SPL_CACHE);
	VM_COUNT_ZONES(&kz, &iz, &hz);
	if (getunsigned("@KERNEL$VM_WIRED_STREAM_QUEUE", &VM_WIRED_STREAM_QUEUE, PG_SIZE_BITS + PG_CLUSTER_BITS, 0, MAXUINT)) {
		unsigned vwsq = (kz + iz + hz) / STREAM_QUEUE_PCT;
		if (__unlikely(vwsq < STREAM_QUEUE_MIN)) vwsq = STREAM_QUEUE_MIN;
		else if (__unlikely(vwsq > STREAM_QUEUE_MAX)) vwsq = STREAM_QUEUE_MAX;
		VM_WIRED_STREAM_QUEUE = vwsq;
	}
	if (getunsigned("@KERNEL$VM_WIRED_STREAM_REACTIVATE", &VM_WIRED_STREAM_REACTIVATE, PG_SIZE_BITS + PG_CLUSTER_BITS, 0, MAXUINT)) {
		if (VM_WIRED_STREAM_QUEUE < STREAM_REACTIVATE * 4) VM_WIRED_STREAM_REACTIVATE = VM_WIRED_STREAM_QUEUE / 4;
		else VM_WIRED_STREAM_REACTIVATE = STREAM_REACTIVATE;
	}
	if (getunsignedlong("@KERNEL$VM_MAX_ENTITIES", &VM_ENTITIES_SOFT_LIMIT, 0, 0, MAXULONG)) {
		__u64 max_entities = (__u64)(kz + iz + hz) * PG_CLUSTER;
		if (max_entities > MAXULONG / 4) max_entities = MAXULONG / 4;
		VM_ENTITIES_SOFT_LIMIT = max_entities;
	}
	{
		unsigned long hard_limit = (VM_ENTITIES_SOFT_LIMIT / 2) * 3;
		if (hard_limit / 3 == (VM_ENTITIES_SOFT_LIMIT / 2)) VM_ENTITIES_HARD_LIMIT = hard_limit;
		else VM_ENTITIES_HARD_LIMIT = -1L;
	}
	{
		unsigned long wm;
		if (!getunsignedlong("@KERNEL$VM_FREEMEM_WATERMARK", &wm, PG_SIZE_BITS + PG_CLUSTER_BITS, 0, MAXULONG)) {
			if (__unlikely(!wm)) wm = 1;
			VM_FREEMEM_WATERMARK = wm;
			VM_REFRESH_WATERMARKS();
		} else {
			VM_FREEMEM_WATERMARK = 0;
			VM_REFRESH_WATERMARKS();
		}
	}
	{
		unsigned unw;
		if (!getunsigned("@KERNEL$VM_DEACTIVATE_TIME", &unw, 0, 0, MAXUINT)) {
			if (__unlikely(unw > MAXUINT / JIFFIES_PER_SECOND)) unw = MAXUINT / JIFFIES_PER_SECOND;
			unw *= JIFFIES_PER_SECOND;
			unw /= VM_WIRESTEPS;
		} else {
			unw = VM_DEFAULT_WIRETIME;
		}
		if (__unlikely(unw < VM_WIREJIFFIES) && __likely(wire_timer.fn != NULL)) {
			KERNEL$DEL_TIMER(&wire_timer);
			KERNEL$SET_TIMER(unw / 2, &wire_timer);
		}
		VM_WIREJIFFIES = unw;
	}
	if (getunsignedlong("@KERNEL$HANDLE_LIMIT", (unsigned long *)&KERNEL$PROC_KERNEL.hq.q_limit, 0, 1, MAXLONG)) {
		KERNEL$PROC_KERNEL.hq.q_limit = MAXLONG;
	}
	if (getunsignedlong("@KERNEL$UIORQ_LIMIT", (unsigned long *)&KERNEL$PROC_KERNEL.uq.q_limit, 0, 1, MAXLONG)) {
		KERNEL$PROC_KERNEL.uq.q_limit = MAXLONG;
	}
	if (getunsignedlong("@KERNEL$IO_LIMIT", (unsigned long *)&KERNEL$PROC_KERNEL.ioq.q_limit, 0, 1, MAXLONG)) {
		KERNEL$PROC_KERNEL.ioq.q_limit = MAXLONG;
	}
	if (getunsignedlong("@KERNEL$PAGETABLE_LIMIT", (unsigned long *)&KERNEL$PROC_KERNEL.pgtblq.q_limit, 0, 1, MAXLONG)) {
		KERNEL$PROC_KERNEL.pgtblq.q_limit = MAXLONG;
	}
	if (getunsignedlong("@KERNEL$VM_LIMIT", (unsigned long *)&KERNEL$PROC_KERNEL.vmq.q_limit, 0, 1, MAXLONG)) {
		KERNEL$PROC_KERNEL.vmq.q_limit = MAXLONG;
	}
	if (getunsignedlong("@KERNEL$PROC_LIMIT", (unsigned long *)&KERNEL$PROC_KERNEL.procq.q_limit, 0, 1, MAXLONG)) {
		KERNEL$PROC_KERNEL.procq.q_limit = MAXLONG;
	}
	LOWER_SPLX(spl);
}

void PARAMS_INIT(void)
{
	static ENV_CALLBACK e = { { NULL, NULL }, REFRESH_PARAMS_CALLBACK };
	KERNEL$REGISTER_ENV_CALLBACK(&e);
}
