#ifndef __KERNEL_PARAMS_H
#define __KERNEL_PARAMS_H

#include <STDLIB.H>

extern unsigned VM_WIRED_STREAM_QUEUE;
extern unsigned VM_WIRED_STREAM_REACTIVATE;
extern unsigned long VM_ENTITIES_SOFT_LIMIT;
extern unsigned long VM_ENTITIES_HARD_LIMIT;
extern unsigned long VM_FREEMEM_WATERMARK;

#define VM_WIRESTEPS			4		/* must be power of 2 */
#define VM_DEFAULT_WIRETIME		(5 * 60 * JIFFIES_PER_SECOND / VM_WIRESTEPS)
extern u_jiffies_lo_t VM_WIREJIFFIES;
extern TIMER wire_timer;

void PARAMS_INIT(void);
void REFRESH_PARAMS(void);

#endif
