#include <ERRNO.H>
#include <SPAD/LIBC.H>
#include <SPAD/AC.H>

#include <SPAD/RANDOM.H>
#include <KERNEL/RANDOM.H>

static void empty(RANDOM_CTX *ctx, void *ptr, int len)
{
}

static void (*random_hook)(RANDOM_CTX *, void *, int) = empty;

__COLD_ATTR__ int KERNEL$REGISTER_RANDOM_HOOK(void (*hook)(RANDOM_CTX *, void *, int))
{
	int spl = KERNEL$SPL;
	RAISE_SPL(SPL_TOP);
	if (hook != NULL) {
		if (__likely(random_hook == empty)) random_hook = hook;
		else {
			LOWER_SPLX(spl);
			return -EEXIST;
		}
	} else {
		if (__unlikely(random_hook == empty)) KERNEL$SUICIDE("KERNEL$REGISTER_RANDOM_HOOK: UNREGISTERING AND NO ACTIVE HOOK");
		random_hook = empty;
	}
	LOWER_SPLX(spl);
	return 0;
}

void KERNEL$ADD_RANDOMNESS(RANDOM_CTX *ctx, void *ptr, int len)
{
	if (__unlikely(FEATURE_TEST(FEATURE_USERSPACE)) && __likely(random_hook == empty)) {
		urandom_add_data(ctx, ptr, len);
		return;
	}
	random_hook(ctx, ptr, len);
}

