#ifndef __KERNEL_SLAB_H
#define __KERNEL_SLAB_H

#include <SPAD/LIST.H>
#include <SPAD/SLAB.H>

#define N_MALLOC_BUCKETS	(sizeof(unsigned long) * 8)
extern struct __slhead MALLOC_BUCKETS[N_MALLOC_BUCKETS];

extern void *STDHEAP_TOP;
#define nonstdheap(p)	((void *)(p) >= STDHEAP_TOP)
extern LIST_HEAD all_slabs;
extern int n_slabs;

void SLAB_ZERO_PREINIT(void);
void SLAB_INIT(void);
void SLAB_INIT_MALLOC_ARENA(void);

#endif
