#include <ARCH/SETUP.H>
#include <ARCH/CPU.H>
#include <SPAD/IRQ.H>
#include <KERNEL/IRQ.H>
#include <KERNEL/SMP/SHARE.H>
#include <KERNEL/ASM.H>
#include <KERNEL/SMP/MATRIX.H>

#include <KERNEL/SMP/IPI.H>

#if __KERNEL_SUPPORT_SMP

static DECL_RT_IRQ_HANDLER(IPI_HALT_FN)
{
	/*__debug_printf("halting cpu %u\n", VAL_CPU_ID);*/
	HALT_CPU();
	IRQ_RETURN;
}

void IPI_INIT(void)
{
	int i;
	if (!FEATURE_TEST(FEATURE_SMP))
		return;
	if (!IRQC.ipi_request)
		KERNEL$SUICIDE("IPI_INIT: IRQ CONTROLLER HAS NO IPI FUNCTION");
	IRQC.ipi_request(IPI_HALT, IPI_HALT_FN, 0);
	for (i = SPL_MATRIX_BOTTOM; i <= SPL_MATRIX_TOP; i++)
		IRQC.ipi_request(IPI_AST + i - SPL_MATRIX_BOTTOM, MATRIX_IPI_RT_IRQ, i - 1);
}

#endif
