#include <SPAD/LIST.H>
#include <SPAD/LIBC.H>
#include <ARCH/CPU.H>
#include <KERNEL/ASM.H>

#include <KERNEL/SMP/SHARE.H>

#if __KERNEL_SUPPORT_SMP

static DECL_XLIST(shared);

void REGISTER_SHARED_POINTER(KERNEL_SHARED *s)
{
	KERNEL_SHARED *sx;
	if (VAL_CPU_ID)
		KERNEL$SUICIDE("REGISTER_SHARED_POINTER: NOT ON BSP");
	XLIST_FOR_EACH(sx, &shared, KERNEL_SHARED, list)
		if (!strcmp(sx->name, s->name))
			KERNEL$SUICIDE("REGISTER_SHARED_POINTER: REGISTERING NAME %s TWICE", s->name);
	ADD_TO_XLIST(&shared, &s->list);
}

void *BSP_FIND_SHARED_POINTER(const char *name)
{
	KERNEL_SHARED *sx;
	if (VAL_CPU_ID)
		KERNEL$SUICIDE("BSP_FIND_SHARED_POINTER: NOT ON BSP");
	XLIST_FOR_EACH(sx, &shared, KERNEL_SHARED, list)
		if (!strcmp(sx->name, name))
			return sx->ptr;
	KERNEL$SUICIDE("BSP_FIND_SHARED_POINTER: SHARED POINTER %s NOT FOUND", name);
}

void *(*FIND_SHARED_POINTER_FN)(const char *name);

void *FIND_SHARED_POINTER(const char *name)
{
	if (!VAL_CPU_ID && FEATURE_PATCHED())
		KERNEL$SUICIDE("FIND_SHARED_POINTER: ON BSP");
	return FIND_SHARED_POINTER_FN(name);
}

#endif
