#ifndef __KERNEL_SMPSHARE_H
#define __KERNEL_SMPSHARE_H

#include <SPAD/LIST.H>
#include <ARCH/SETUP.H>

typedef struct {
	const char *name;
	void *ptr;
	LIST_ENTRY list;
} KERNEL_SHARED;

#if __KERNEL_SUPPORT_SMP
void REGISTER_SHARED_POINTER(KERNEL_SHARED *s);
#else
static __finline__ void REGISTER_SHARED_POINTER(KERNEL_SHARED *s) {}
#endif

void *FIND_SHARED_POINTER(const char *name);

void *BSP_FIND_SHARED_POINTER(const char *name);
extern void *(*FIND_SHARED_POINTER_FN)(const char *name);

int VALID_CPU_ID(__cpu_id_t cpu);
void *GET_KERNEL_VAR(void *ptr, __cpu_id_t cpu);

#define for_all_cpus(c)		\
	for (c = 0; c < VAL_CPU_ID_LIMIT; c++) if (VALID_CPU_ID(c))

#define for_other_cpus(c)	\
	for (c = 0; c < VAL_CPU_ID_LIMIT; c++) if (c != VAL_CPU_ID && VALID_CPU_ID(c))

__node_id_t CPU_NODE(__cpu_id_t);

#endif
