#include <ARCH/BITOPS.H>
#include <ARCH/TIME.H>
#include <SPAD/LIBC.H>

#include <SPAD/SPINLOCK.H>

void KERNEL$SPINLOCK_INIT(SPINLOCK *sp)
{
	sp->__s2 = 0;
}

void KERNEL$SPINLOCK_LOCK(SPINLOCK *sp)
{
	__spinlock_val_t val;
	val = __SPINLOCK_XADD(&sp->__s1.__ticket, 1);
	if (__unlikely(val != sp->__s1.__value)) {
		a:
		MONITOR(&sp->__s1.__value);
		if (__unlikely(val == sp->__s1.__value))
			goto done;
		MWAIT();
		if (__unlikely(val != sp->__s1.__value))
			goto a;
	}
	done:
	__read_barrier();
}

void KERNEL$SPINLOCK_UNLOCK(SPINLOCK *sp)
{
	__write_barrier();
#if __DEBUG >= 2
	if (__unlikely(sp->__s1.__value == sp->__s1.__ticket))
		KERNEL$SUICIDE("KERNEL$SPINLOCK_UNLOCK: UNLOCKING UNLOCKED SPINLOCK");
#endif
	sp->__s1.__value++;
}
