#ifndef __KERNEL_SYSDEF_H
#define __KERNEL_SYSDEF_H

#include <KERNEL/ASMDEF.H>

#define SYS(x)			((x) << SYSCALL_SHIFT)
#define SYS_EXTENDED_PARAM	((1 << SYSCALL_SHIFT) - 1)

#define SYS_UNMAP_RANGE		SYS(1)	/* args: start, len */
#define SYS_UNMAP_DEALLOC_RANGE	(SYS(1)+1)
#define SYS_EXIT		SYS(2)	/* args: error code, ptr to error string */
#define SYS_OPEN		SYS(3)	/* args: flags(sys), RQ, handle */
#define SYS_READ		SYS(4)	/* args: RQ */
#define SYS_WRITE		(SYS(4)+1) /* args: RQ */
#define SYS_AREAD		SYS(5)	/* args: RQ */
#define SYS_AWRITE		(SYS(5)+1) /* args: RQ */
#define SYS_IOCTL		SYS(6)
#define SYS_BLOCK		SYS(7)	/* args: ptr, expected value to block */
#define SYS_CLOSE		SYS(8)	/* args: AST to post, handle number */
#define SYS_FAST_CLOSE		SYS(9)	/* args: handle number */
#define SYS_SET_TIMER		SYS(10)	/* args: time in jiffies: lo, hi */
#define SYS_LN_UNBLOCK		SYS(11)
#define SYS_LN_LIST		SYS(12)
#define SYS_SPAWN		SYS(13)	/* args: ptr to KSPAWNRQ */
#define SYS_FORK		(SYS(13)+1) /* args: ptr to KSPAWNRQ */
#define SYS_CANCEL		SYS(14)	/* args: ptr to RQ */
#define SYS_DEPTH		SYS(15)	/* no args */
#define SYS_BREAK		SYS(16)
#define SYS_EXEC		SYS(17)
#define SYS_CANCEL_ALL		SYS(18)
#define SYS_INVD_EXTD_PAGE	SYS(19) /* args: max IOBMP_PAGES + LDT_PAGES */
#define SYS_FLUSH_LN_CACHE	SYS(20)

#define KERNEL_CALL_READ	0
#define KERNEL_CALL_WRITE	1
#define KERNEL_CALL_AREAD	2
#define KERNEL_CALL_AWRITE	3
#define KERNEL_CALL_IOCTL	4
#define KERNEL_CALL_OPEN	5
#define KERNEL_CALL_CLOSE	6
#define KERNEL_CALL_FAKE_CLOSE	7
#define KERNEL_CALL_MAX		8

#endif
