#include <SPAD/LIBC.H>
#include <STRING.H>
#include <ARCH/IO.H>
#include <SPAD/SHELL.H>
#include <SYS/TYPES.H>
#include <STDLIB.H>
#include <SPAD/WQ.H>
#include <SPAD/CONSOLE.H>

#include <SPAD/SYSLOG.H>
#include <KERNEL/SYSLOG.H>

static const char * const lclasses[] = {
	NULL,
	"HW BUG",
	"HW NONFATAL BUG",
	"HW ERROR",
	"HW INCOMPATIBILITY",
	"HW INCAPABILITY",
	"HW INFO",
	"RESOURCE CONFLICT",
	"SW INCOMPATIBILITY",
	"SW ERROR",
	"CONF ERROR",
	"SW INFO",
	"DATA ERROR",
	"HW WARNING",
	"SW WARNING",
	"DATA NONFATAL ERROR",
	"NET ERROR",
	"NET WARNING",
	"AUTH INFO",
	"NET NONTFATAL ERROR",
	NULL
};

void KERNEL$SYSLOGV(int lclass, const char *device, const char *msg, va_list args)
{
	int int_state;
	int v;
	char *p;
	char s[2];
	int flags = lclass;
	lclass &= __SYSLOG_CLASS;
	if (__unlikely(lclass <= 0)) KERNEL$SUICIDE("KERNEL$SYSLOG: CLASS %d", lclass);
	if (__unlikely(lclass >= sizeof lclasses / sizeof(const char *))) lclass = __SYSLOG_HW_INFO;
	if (__likely(lclass == __SYSLOG_AUTH_INFO)) {
		char *e = getenv("@KERNEL$AUTH_LOG_CONSOLE");
		if (__likely(!e) || __unlikely(e[0] != '1') || __unlikely(e[1])) goto skip_cons;
	}
	if (__likely(!(flags & __SYSLOG_SECRET)) || __unlikely(FEATURE_TEST(FEATURE_USERSPACE))) {
		KERNEL$CONSOLE_LOCK();
		__critical_printf("%s ON %s: ", lclasses[lclass], device);
		__critical_vprintf(msg, args);
		__critical_printf("\n");
		KERNEL$CONSOLE_UNLOCK();
	}
	skip_cons:
	if (__unlikely(FEATURE_TEST(FEATURE_USERSPACE))) return;
	int_state = KERNEL$SAVE_INT_STATE();
	KERNEL$DI();
	if (__unlikely(log_buffer_overflow)) goto ei;
	if (__unlikely(strlen(lclasses[lclass]) + strlen(device) + 4 + log_buffer_end > LOG_BUFFER_SIZE)) {
		bo:
		log_buffer_overflow = 1;
		goto ei;
	}
	s[0] = flags & __SYSLOG_SECRET ? '1' : '0';
	s[1] = 0;
	p = stpcpy(stpcpy(stpcpy(log_buffer + log_buffer_end, s) + 1, lclasses[lclass]) + 1, device) + 1;
	v = _vsnprintf(p, log_buffer + LOG_BUFFER_SIZE - p, msg, args);
	if (__unlikely(v == -1)) goto bo;
	p += v + 1;
	log_buffer_end = p - log_buffer;
	
	ei:
	KERNEL$RESTORE_INT_STATE(int_state);
}

void __PRINTF_ATTR__(3,4) KERNEL$SYSLOG(int lclass, const char *device, const char *msg, ...)
{
	va_list args;
	va_start(args, msg);
	KERNEL$SYSLOGV(lclass, device, msg, args);
	va_end(args);
}

DECL_IOCALL(KERNEL$SYNC_SYSLOG, SPL_TIMER, LOGRQ)
{
	if (FEATURE_TEST(FEATURE_USERSPACE)) {
		KERNEL$SYSLOG(RQ->lclass, RQ->device, "%s", RQ->msg);
		RQ->status = 0;
		RETURN_AST(RQ);
	}
	if (__unlikely(log_buffer_overflow)) {
		wait:
		WQ_WAIT(&log_wait, RQ, KERNEL$SYNC_SYSLOG);
		RETURN;
	}
	KERNEL$SYSLOG(RQ->lclass, RQ->device, "%s", RQ->msg);
	if (__unlikely(log_buffer_overflow)) goto wait;
	WQ_WAIT(&log_wait, RQ, KERNEL$SUCCESS);
	RETURN;
}

