#ifndef __KERNEL_TIMER_H
#define __KERNEL_TIMER_H

#include <SPAD/IRQ.H>
#include <ARCH/TIME.H>

extern IRQ_STUB TIMER_IRQ;
void KTIMER_INIT(void);

int TIMER_DISABLE(void);
void TIMER_ENABLE(int state);
void TIMER_FORK(void);

#define __TIMER_GET_JIFFIES(t)		__make64((t)->__time_lo, (t)->__time_hi)
static __finline__ void __TIMER_SET_JIFFIES(TIMER *__t, u_jiffies_t __j)
{
	__t->__time_lo = __j;
	__t->__time_hi = __j >> 32;
}

#endif
