#ifndef AT
#define op	open
#define at_arg
#else
#define op	openat
#define at_arg	int dirfd,
#endif

int op(at_arg const char *path, int oflags, ...)
{
	OPENRQ o;
	const char *to_free = NULL;
#ifdef AT
	CWD cwd;
	CWDE cwde;
	char *p;
#endif
	__cancel_test();
#ifdef AT
	if (__unlikely(!path)) {
		if (__unlikely(dirfd == AT_FDCWD)) {
			errno = EINVAL;
			goto ret__1;
		}
		path = "";
		goto do_at;
	}
#endif
	if (__unlikely(!path[0])) {
		errno = ENOENT;
		goto ret__1;
	}
	if (__unlikely(path[0] == '/') && __unlikely(path[1] == 'd') && __likely(path[2] == 'e') && __likely(path[3] == 'v') && __likely(path[4] == '/')) {
		path = open_translate_unx(path, &to_free);
	}
#ifdef AT
	if (dirfd != AT_FDCWD) {
		do_at:
		p = KERNEL$HANDLE_PATH(dirfd);
		if (__unlikely(!p)) {
			errno = EBADF;
			goto ret__1;
		}
		make_cwd(cwd, cwde, p);
	}
#endif
	if (__unlikely(oflags & (O_NONBLOCK | O_DIRECT | _O_RENAME))) {
		va_list va;
		if (__likely(!(oflags & _O_RENAME))) {
#ifdef AT
			if (dirfd != AT_FDCWD) {
				o.status = open_special(&cwd, path, oflags);
			} else
#endif
			{
				o.status = open_special(KERNEL$CWD(), path, oflags);
			}
			goto ret_o_status;
		}
		va_start(va, oflags);
		o.rename_handle = va_arg(va, int);
		va_end(va);
	}
	o.flags = oflags;
	o.path = path;
#ifdef AT
	if (dirfd != AT_FDCWD) {
		o.cwd = &cwd;
	} else
#endif
	{
		o.cwd = KERNEL$CWD();
	}
	SYNC_IO(&o, KERNEL$OPEN);
	/*__debug_printf("open(%s,%o)->%d\n", o.path, o.flags, o.status);*/
	/*KERNEL$STACK_DUMP();*/
	if (__unlikely(o.status < 0)) {
		errno = -o.status;
		ret__1:
		o.status = -1;
	}
	ret_o_status:
	if (__unlikely(to_free != NULL)) free((void *)to_free);
	return o.status;
}

#undef op
#undef at_arg

#ifdef AT
#undef AT
#endif
