#include <STDARG.H>
#include <ERRNO.H>
#include <STDLIB.H>
#include <STRING.H>

#include <SYS/WAIT.H>
#include <UNISTD.H>

pid_t wait(int *status)
{
	return waitpid(WAIT_ANY, status, 0);
}

int execl(const char *path, const char *arg, ...)
{
	int n;
	char **argv;
	va_list a;
	va_start(a, arg);
	n = 1;
	while (va_arg(a, char *) != NULL) n++;
	va_end(a);
	argv = alloca((n + 1) * sizeof(char *));
	argv[0] = (char *)arg;
	va_start(a, arg);
	n = 1;
	while ((argv[n] = va_arg(a, char *))) n++;
	va_end(a);
	return execve(path, argv, NULL);
}

int execle(const char *path, const char *arg, ...)
{
	int n;
	char **argv, **env;
	va_list a;
	va_start(a, arg);
	n = 1;
	while (va_arg(a, char *) != NULL) n++;
	va_end(a);
	argv = alloca((n + 1) * sizeof(char *));
	argv[0] = (char *)arg;
	va_start(a, arg);
	n = 1;
	while ((argv[n] = va_arg(a, char *))) n++;
	env = va_arg(a, char **);
	va_end(a);
	return execve(path, argv, env);
}

int execv(const char *path, char *const argv[])
{
	return execve(path, argv, NULL);
}

int execlp(const char *file, const char *arg, ...)
{
	int n;
	char **argv;
	va_list a;
	va_start(a, arg);
	n = 1;
	while (va_arg(a, char *) != NULL) n++;
	va_end(a);
	argv = alloca((n + 1) * sizeof(char *));
	argv[0] = (char *)arg;
	va_start(a, arg);
	n = 1;
	while ((argv[n] = va_arg(a, char *))) n++;
	va_end(a);
	return execvp(file, argv);
}

int execvp(const char *file, char *const argv[])
{
	char *a;
	char *path;
	if (__unlikely(strchr(file, '/') != NULL) || __unlikely(strchr(file, ':') != NULL))
		return execv(file, argv);
	path = getenv("PATH");
	if (path) {
		char *n;
		next_elem:
		n = strchr(path, ';');
		if (__unlikely(!n)) n = path + strlen(path);
		if (__likely(n != path)) {
			a = malloc(n - path + strlen(file) + 2);
			if (__unlikely(!a)) return -1;
			memcpy(a, path, n - path);
			a[n - path] = 0;
			if (a[n - path - 1] != '/') strcat(a, "/");
			strcat(a, file);
			execve(a, argv, NULL);
			free(a);
		}
		if (__likely(*n)) {
			path = n + 1;
			goto next_elem;
		}
	}
	a = malloc(strlen(file) + /*strlen("PATH.:/")*/ 7 + 1);
	if (__unlikely(!a)) return -1;
	strcpy(stpcpy(a, "PATH.:/"), file);
	execve(a, argv, NULL);
	free(a);
	return -1;
}

