#ifndef __KERNEL_VM_H
#define __KERNEL_VM_H

#include <ARCH/SETUP.H>
#include <SPAD/VM.H>
#include <SPAD/WQ.H>
#include <SPAD/DEV_KRNL.H>
#include <KERNEL/SMP/SHARE.H>

#if __DEBUG >= 1
#define SPLVSPACEASSERT(s)	\
do {				\
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_VSPACE))) KERNEL$SUICIDE("%s AT SPL %08X", (s), KERNEL$SPL);\
} while(0)
#else
#define SPLVSPACEASSERT(s)	\
do { } while (0)
#endif

extern MTX VM_MUTEX;

extern WQ WRITEBACK_WAIT;
extern WQ FREEMEM_ABOVE;
extern WQ FREE_ENTITIES;

void MEMORY_BALANCE(void);
void VM_ADD_PAGE(PAGE *p, int res, __node_id_t);
void VM_ADDED_PAGES(void);
int VM_RELEASE_PAGES(unsigned long from, unsigned long to_reserve, unsigned long to);
void KERNEL_VM_INIT(void);
void KERNEL_VM_INIT_2(void);
void VM_RESET_ZONES(int bank);
void VM_COUNT_ZONES(unsigned long *kernel, unsigned long *io, unsigned long *high);
void VM_REFRESH_WATERMARKS(void);

void KERNEL_TRANSFER_VM_STATE(int type_from, int type_to);

extern unsigned IO_IN_PROGRESS;
extern unsigned long VM_ENTITIES;

unsigned long CACHE_UPCALL(unsigned long needed);
const char *CACHE_DUMPQ(void);

void *MAKE_USER_SIZES(size_t s);
int MAKE_USER_PAGES(void);

typedef struct {
	size_t size;
} USER_SIZE_DESC;

extern USER_SIZE_DESC *USER_SIZE_DESCS;
extern PAGE *USER_PAGE_DESCS;

void VM_CHECK_MAGICS(void);

extern __p_addr ZERO_PAD_PHYS;

vspace_dmaunlock_t *KERNEL_DO_BOUNCE(VDESC *desc, int rw, VDMA *vdma);
__p_addr KERNEL_DO_UNBOUNCE(__u32 paddr);
void BOUNCE_INIT(void);

#endif
