#include <KERNEL/DEV.H>
#include <KERNEL/VM.H>
#include <SPAD/AC.H>
#include <SYS/TYPES.H>
#include <SPAD/VM.H>
#include <STRING.H>
#include <SPAD/LIBC.H>

/* --- VIRTUAL --- */

static unsigned long VIRTUAL_GET(VDESC *desc, const VBUF *buf);
static unsigned long VIRTUAL_PUT(VDESC *desc, const VBUF *buf);
static IORQ *VIRTUAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw);

const HANDLE_OPERATIONS VIRTUAL_OPERATIONS = {
	0,
	VIRTUAL_GET,
	VIRTUAL_PUT,
	VIRTUAL_MAP,
	VIRTUAL_DMALOCK,
	VIRTUAL_DMA64LOCK,
	VIRTUAL_PHYSLOCK,
	VIRTUAL_GET_PAGEIN_RQ,
};

static unsigned long VIRTUAL_GET(VDESC *desc, const VBUF *buf)
{
	unsigned long s;
	SPLVSPACEASSERT("VIRTUAL_GET");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	memcpy(buf->ptr, (void *)(unsigned long)desc->ptr, s);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

static unsigned long VIRTUAL_PUT(VDESC *desc, const VBUF *buf)
{
	unsigned long s;
	/*__asm__ volatile ("movl %%cr3, %%eax; movl %%eax, %%cr3":::"ax");*/
	SPLVSPACEASSERT("VIRTUAL_PUT");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	memcpy((void *)(unsigned long)desc->ptr, buf->ptr, s);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

__COLD_ATTR__ static IORQ *VIRTUAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw)
{
	KERNEL$SUICIDE("VIRTUAL_GET_PAGEIN_RQ CALLED");
	return NULL;
}

/* --- NULL --- */

__COLD_ATTR__ unsigned long KERNEL$NO_VSPACE_GET(VDESC *desc, const VBUF *buf)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_GET");
	LOWER_SPLX(buf->spl);
	return 0;
}

__COLD_ATTR__ unsigned long KERNEL$NO_VSPACE_PUT(VDESC *desc, const VBUF *buf)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_PUT");
	LOWER_SPLX(buf->spl);
	return 0;
}

__COLD_ATTR__ void *KERNEL$NO_VSPACE_MAP(VDESC *desc, int rw, int spl, vspace_unmap_t **unmap)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_MAP");
	LOWER_SPLX(spl);
	return NULL;
}

__COLD_ATTR__ vspace_dmaunlock_t *KERNEL$NO_VSPACE_DMALOCK(VDESC *desc, int rw, VDMA *dma)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_DMALOCK");
	LOWER_SPLX(dma->spl);
	return NULL;
}

__COLD_ATTR__ vspace_dma64unlock_t *KERNEL$NO_VSPACE_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_DMA64LOCK");
	LOWER_SPLX(dma->spl);
	return NULL;
}

__COLD_ATTR__ vspace_physunlock_t *KERNEL$NO_VSPACE_PHYSLOCK(VDESC *desc, int rw, VPHYS *p)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_PHYSLOCK");
	LOWER_SPLX(p->spl);
	return NULL;
}

__COLD_ATTR__ IORQ *KERNEL$NO_VSPACE_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int wr)
{
	SPLVSPACEASSERT("KERNEL$NO_VSPACE_GET_PAGEIN_RQ");
	rq->status = -ENOVSPACE;
	CALL_AST(rq);
	return NULL;
}

__COLD_ATTR__ PAGE *KERNEL$NO_VSPACE_GET_PAGE(HANDLE *h, __v_off idx, int wr)
{
	return __ERR_PTR(-ENOVSPACE);
}

__COLD_ATTR__ int KERNEL$NO_VSPACE_SWAP_OP(HANDLE *h, int op, ...)
{
	return 0;
}

