#include <KERNEL/DEV.H>
#include <KERNEL/VM.H>
#include <SPAD/AC.H>
#include <SYS/TYPES.H>
#include <SPAD/VM.H>
#include <STRING.H>
#include <SPAD/LIBC.H>

static const HANDLE_OPERATIONS PHYSICAL_OPERATIONS;

HANDLE KERNEL$PHYSICAL = { &PHYSICAL_OPERATIONS };
HANDLE KERNEL$VIRTUAL = { &VIRTUAL_OPERATIONS };

/* --- PHYSICAL --- */

vspace_dmaunlock_t *PHYSICAL_DMALOCK(VDESC *desc, int rw, VDMA *dma);
vspace_dma64unlock_t *PHYSICAL_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma);
vspace_physunlock_t *PHYSICAL_PHYSLOCK(VDESC *desc, int rw, VPHYS *dma);

static unsigned long PHYSICAL_GET(VDESC *desc, const VBUF *buf);
static unsigned long PHYSICAL_PUT(VDESC *desc, const VBUF *buf);
static void *PHYSICAL_MAP(VDESC *desc, int rw, int spl, vspace_unmap_t **unmap);
static void PHYSICAL_UNMAP(void *ptr);
static IORQ *PHYSICAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw);

static const HANDLE_OPERATIONS PHYSICAL_OPERATIONS = {
	0,
	PHYSICAL_GET,
	PHYSICAL_PUT,
	PHYSICAL_MAP,
	PHYSICAL_DMALOCK,
	PHYSICAL_DMA64LOCK,
	PHYSICAL_PHYSLOCK,
	PHYSICAL_GET_PAGEIN_RQ,
};

static void *PHYSICAL_MAP(VDESC *desc, int rw, int spl, void (**unmap)(void *))
{
	SPLVSPACEASSERT("PHYSICAL_MAP");
	LOWER_SPLX(spl);
	*unmap = PHYSICAL_UNMAP;
	return KERNEL$MAP_PHYSICAL_BANK(desc->ptr);
}

static void PHYSICAL_UNMAP(void *ptr)
{
	KERNEL$UNMAP_PHYSICAL_BANK(ptr);
}

static unsigned long PHYSICAL_GET(VDESC *desc, const VBUF *buf)
{
	void *p;
	unsigned long s;
	SPLVSPACEASSERT("PHYSICAL_GET");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	p = KERNEL$MAP_PHYSICAL_BANK(desc->ptr);
	memcpy(buf->ptr, p, s);
	KERNEL$UNMAP_PHYSICAL_BANK(p);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

static unsigned long PHYSICAL_PUT(VDESC *desc, const VBUF *buf)
{
	void *p;
	unsigned long s;
	SPLVSPACEASSERT("PHYSICAL_PUT");
	LOWER_SPLX(buf->spl);
	s = buf->len;
	if (s > desc->len) s = desc->len;
	p = KERNEL$MAP_PHYSICAL_BANK(desc->ptr);
	memcpy(p, buf->ptr, s);
	KERNEL$UNMAP_PHYSICAL_BANK(p);
	*__VOFF2U32(&desc->ptr) += s;
	desc->len -= s;
	return s;
}

__COLD_ATTR__ static IORQ *PHYSICAL_GET_PAGEIN_RQ(VDESC *desc, IORQ *rq, int rw)
{
	KERNEL$SUICIDE("PHYSICAL_GET_PAGEIN_RQ CALLED");
	return NULL;
}


