static void UNL(UNL_TYPE ptr);
static void UNL_SPAGE(UNL_TYPE ptr);
#ifdef UNL_ZERO
static void UNL_ZERO(UNL_TYPE ptr);
#endif

FN
{
	PROC *p;
	PAGE *pg;
	unsigned off;
	unsigned long l;

	SPLVSPACEASSERT(FN_NAME);

	if (__unlikely(!desc->len))
		KERNEL$SUICIDE(FN_NAME ": TRYING TO LOCK NULL DESCRIPTOR AT %" __64_format "X", (__u64)desc->ptr);

	p = GET_STRUCT(desc->vspace, PROC, vspace);
	pg = VM_ARCH_GET_PAGE(p, (unsigned long)desc->ptr, rw & PF_WRITE);
	if (__unlikely(!pg)) {
		ret0:
		RET_ZERO;
	}
	if (__unlikely(!IS_PAGE_POINTER(pg))) {
#define sp	((SPAGE *)pg)
		off = (unsigned long)desc->ptr & (PAGE_CLUSTER_SIZE - 1);
		if (__unlikely(off >= sp->n_pages << PG_SIZE_BITS)) {
			l = desc->len;
			if (l > PAGE_CLUSTER_SIZE - off) l = PAGE_CLUSTER_SIZE - off;
#ifdef UNL_ZERO
			RET_MAP(ZERO_PAD_PHYS, l, rw, UNL_ZERO);
#else
			RET_MAP(ZERO_PAD_PHYS, l, rw, KERNEL$NULL_VSPACE_PHYSUNLOCK);
#endif
		}
		if (__unlikely(sp->lockdown(sp, 0) != NULL)) {
			goto ret0;
		}
		l = desc->len;
		if (__unlikely(l > (sp->n_pages << PG_SIZE_BITS) - off))
			l = (sp->n_pages << PG_SIZE_BITS) - off;
		RET_MAP(PAGE_2_PHYS(sp->page) | (sp->offset + off), l, rw, UNL_SPAGE);
#undef sp
	}
	if (__unlikely(pg->lockdown(pg, 0) != NULL)) {
		goto ret0;
	}
	off = (unsigned long)desc->ptr & (PAGE_CLUSTER_SIZE - 1);
	l = desc->len;
	if (l > PAGE_CLUSTER_SIZE - off) l = PAGE_CLUSTER_SIZE - off;
	RET_MAP(PAGE_2_PHYS(pg) | off, l, rw, UNL);
}

static void UNL(UNL_TYPE ptr)
{
	int spl;
	PAGE *p;
	p = DO_UNMAP(ptr);
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_VSPACE);
	p->lockdown(p, 1);
	LOWER_SPLX(spl);
}

static void UNL_SPAGE(UNL_TYPE ptr)
{
	int spl;
	PAGE *p;
	unsigned pos;
	SPAGE *s;
	p = DO_UNMAP(ptr);
	pos = ((unsigned)ptr & (PAGE_CLUSTER_SIZE - 1)) >> PG_SIZE_BITS;
	s = (SPAGE *)((SPAGES *)p->fnode)->s[pos + 1].freelist.next;
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_VSPACE);
	s->lockdown(s, 1);
	LOWER_SPLX(spl);
}

#ifdef UNL_ZERO
static void UNL_ZERO(UNL_TYPE ptr)
{
	PAGE *p = DO_UNMAP(ptr);
	p = NULL;	/* shut up warning */
}
#endif

#undef FN
#undef FN_NAME
#undef UNL
#undef UNL_SPAGE
#undef UNL_TYPE
#ifdef UNL_ZERO
#undef UNL_ZERO
#endif
#undef RET_ZERO
#undef RET_MAP
#undef DO_UNMAP
