#ifndef __LIB_CHARSET_CHRCACHE_H
#define __LIB_CHARSET_CHRCACHE_H

#include <SPAD/LIST.H>

typedef struct __chrcache CHRCACHE;

#define CHRCACHE_HEAD				\
	LIST_ENTRY list;			\
	char *name;				\
	unsigned char type;			\
	unsigned char leave;			\
	int refcount;				\
	time_t last_use;			\
	void (*destructor)(struct __chrcache *ch)

struct __chrcache {
	CHRCACHE_HEAD;
};

#define TYPEFLAG_FILE	0x40
#define TYPE_8B		(TYPEFLAG_FILE | 1)
#define TYPE_FALLBACK	(TYPEFLAG_FILE | 2)
#define TYPE_ALIAS	(TYPEFLAG_FILE | 3)

#define TYPE_ICONV	1

CHRCACHE *CHRCACHE_OPEN(const char *name, int type, const char *default_ext, int size_of, int (*init)(CHRCACHE *chr, unsigned long h));
void CHRCACHE_CLOSE(CHRCACHE *ch, int keep, int type_check);
int READ_BY_LINES(CHRCACHE *chr, int h, int (*process_line)(CHRCACHE *chr, char *line, size_t len));

#endif
