#ifndef __LIB_CHARSET_CHRICONV_H
#define __LIB_CHARSET_CHRICONV_H

#include <SYS/TYPES.H>

struct iconv_charset {
	ssize_t (*get_char)(const char *buf, size_t len, __s32 *uni, void *state);
	ssize_t (*put_char)(char *buf, size_t len, __s32 uni, void *state);
	void (*free_charset)(void *ex);
	void *(*init_state)(void *ex);
	void (*free_state)(void *state);
};

#define ICONV_ERROR		-1
#define ICONV_FALLBACK_NEEDED	-2

const struct iconv_charset *ICONV_GET_CHARSET(const char *name, void **ex);

#endif
