#include <SPAD/SYNC.H>
#include <SPAD/READDIR.H>
#include <DIRENT.H>
#include <STRING.H>
#include <STDLIB.H>
#include <SPAD/CHARSET.H>

static void LIST_EXTENSION(const char *ext, void (*process)(const char *name, void *cookie), void *cookie)
{
	READDIR_RQ r;
	unsigned long l;
	r.cwd = KERNEL$CWD();
	r.flags = 0;
	r.path = "ETC.:/CHARSETS/";
	SYNC_IO(&r, KERNEL$READDIR);
	if (__unlikely(r.status != 0)) return;

	for (l = 0; l < r.n_entries; l++) {
		char *name = r.entries[l]->d_name;
		char *p = strchr(name, '.');
		if (__likely(p != NULL) && !strcmp(p + 1, ext)) {
			*p = 0;
			process(name, cookie);
		}
	}
	KERNEL$FREE_READDIR(&r);
}

void CHARSET$LIST_8B(void (*process)(const char *name, void *cookie), void *cookie)
{
	LIST_EXTENSION("CH8", process, cookie);
}

struct lali {
	void (*process)(const char *name, void *cookie);
	void *cookie;
	const char *name;
};

static void LIST_ALI_TEST(const char *name, void *lali_);

void CHARSET$LIST_ALIASES(const char *name, void (*process)(const char *name, void *cookie), void *cookie)
{
	struct lali lali;
	lali.process = process;
	lali.cookie = cookie;
	lali.name = name;
	LIST_EXTENSION("ALI", LIST_ALI_TEST, &lali);
}

static void LIST_ALI_TEST(const char *name, void *lali_)
{
	char *r;
	struct lali *lali = lali_;
	r = CHARSET$RESOLVE_ALIAS(name);
	if (__unlikely(!r)) return;
	if (__likely(_strcasecmp(r, lali->name))) goto free_ret;
	lali->process(name, lali->cookie);
	free_ret:
	free(r);
}
