#include <STRING.H>
#include <STDLIB.H>

#include <SPAD/CHARSET.H>

int CHARSET$8B28B_FALLBACK(CHARSET_8B *from, CHARSET_8B *to, FALLBACK *fb, unsigned char chr)
{
	int uni = CHARSET$8B2UNI(from, chr);
	if (__unlikely(uni < 0)) return uni;
	return CHARSET$UNI28B_FALLBACK(to, fb, uni);
}

int CHARSET$UNI28B_FALLBACK(CHARSET_8B *to, FALLBACK *fb, __s32 uni)
{
	__s32 *strl;
	unsigned order;
	int b = CHARSET$UNI28B(to, uni);
	if (__likely(b >= 0)) return b;
	for (order = 0; (strl = CHARSET$GET_FALLBACK(fb, uni, order)); order++) {
		if (__unlikely(strl[0] == -1) || __unlikely(strl[1] != -1)) continue;
		b = CHARSET$UNI28B(to, strl[0]);
		if (__likely(b >= 0)) return b;
	}
	return -1;
}

