#include <STDLIB.H>
#include <ARCH/BITOPS.H>
#include <SYS/TIME.H>

#include "../PTHREAD/PTHREAD.H"

#include <SEMAPHORE.H>

/* TODO: use wait queues when within one process */

struct __sem_t {
	int value;
};

int sem_init(sem_t *sem, int pshared, unsigned value)
{
	struct __sem_t *s = malloc(sizeof(struct __sem_t));
	if (!s)
		return -1;
	s->value = value;
	*sem = s;
	return 0;
}

int sem_destroy(sem_t *sem)
{
	free(*sem);
	return 0;
}

int sem_getvalue(sem_t *sem, int *sval)
{
	*sval = (*sem)->value;
	return 0;
}

int sem_post(sem_t *sem)
{
	__ADDI(&(*sem)->value, 1);
	return 0;
}

static int sem_wait_internal(struct __sem_t *s, struct timeval *et);

int sem_wait(sem_t *sem)
{
	return sem_wait_internal(*sem, NULL);
}

static int sem_wait_internal(struct __sem_t *s, struct timeval *et)
{
	int v;
	again:
	while (__unlikely((v = s->value) <= 0)) {
		if (__unlikely(et != NULL)) {
			struct timeval ct;
			gettimeofday(&ct, NULL);
			if (__unlikely(ct.tv_sec > et->tv_sec))
				return -1;
			if (ct.tv_sec == et->tv_sec && ct.tv_usec >= et->tv_usec)
				return -1;
		}
		pth_sleep();
	}
	if (__unlikely(__CMPXCHGI(&s->value, v, v - 1) != 0))
		goto again;
	return 0;
}

int sem_trywait(sem_t *sem)
{
	struct timeval nul;
	int r;
	nul.tv_sec = 0;
	nul.tv_usec = 0;
	r = sem_wait_internal(*sem, &nul);
	if (__unlikely(r)) errno = EAGAIN;
	return r;
}

int sem_timedwait(sem_t *sem, const struct timespec *abs_timeout)
{
	struct timeval t;
	int r;
	if (__unlikely((unsigned long)abs_timeout->tv_nsec >= 1000000000)) {
		errno = EINVAL;
		return -1;
	}
	t.tv_sec = abs_timeout->tv_sec;
	t.tv_usec = abs_timeout->tv_nsec / 1000;
	r = sem_wait_internal(*sem, &t);
	if (__unlikely(r)) errno = ETIMEDOUT;
	return r;
}
