#include <SPAD/DL.H>
#include <STDLIB.H>
#include <LIB/KERNEL/UASM.H>
#include <LIB/KERNEL/UTHREAD.H>
#include <LIB/KERNEL/UIO.H>
#include <LIB/KERNEL/USIGNAL.H>
#include <UNISTD.H>
#include <KERNEL/TIMER.H>
#include <KERNEL/ENV.H>
#include <KERNEL/SLAB.H>
#include <ARCH/CPU.H>

void KERNEL$BOOT(char **env);

extern const char *__progname;
extern void (*__exit_func)(int);

void KERNEL$BOOT(char **env)
{
	START_ARG start;
	long ret;
#if __DEBUG >= 1
	if (__unlikely(!FEATURE_TEST(FEATURE_USERSPACE)))
		KERNEL$SUICIDE("KERNEL.DLL NOT PATCHED");
#endif
	KERNEL$PHYSICAL.op = &VIRTUAL_OPERATIONS;
	SLAB_INIT();
	__DL_USER_INIT(1);
	ENV_INIT();
	UIO_RST_INIT();	/* must be before timer */
	KTIMER_INIT();
	UIO_INIT();
	THREAD_INIT();
	UIO_DUPSTD();
	SIGNAL_INIT();
	environ = env;
	start.env = env;
	while (*env++) ;
	start.argv = (const char * const *)env;
	__progname = start.argv[0];

	ret = __DL_USER_LOAD_EXE(start.argv[0], &start, &udata.dl_exe);
	if (__likely(__exit_func != NULL)) __exit_func(ret);
	KERNEL$DL_CALL_DTORS();
	_exit(ret);
}
