#include <SPAD/LIBC.H>
#include <FCNTL.H>
#include <SPAD/LIST.H>
#include <STRING.H>
#include <STDLIB.H>
#include <LIMITS.H>
#include <PATHS.H>
#include <SYS/MMAN.H>
#include <LIB/KERNEL/USIGNAL.H>
#include <KERNEL/UDATA.H>
#include <LIB/KERNEL/UASM.H>
#include <KERNEL/DEV.H>
#include <KERNEL/SYSCALL.H>
#include <ARCH/BARRIER.H>
#include <KERNEL/TIMER.H>
#include <LIB/KERNEL/UIO.H>
#include <LIB/KERNEL/UTHREAD.H>
#include <SPAD/DL.H>
#include <SPAD/CD.H>
#include <SPAD/SYNC.H>
#include <KERNEL/ENV.H>
#include <KERNEL/SLAB.H>
#include <SYS/WAIT.H>
#include <SPAD/TIMER.H>
#include <SPAD/LIBPROC.H>

#include <UNISTD.H>

static int transparent_fork(void);

static struct {
	const char *unx, *spd;
} unx_trans[] = {
	"/bin/sh", _PATH_BSHELL,
	"/bin/bash", _PATH_BASH,
	NULL, NULL,
};

static const char *translate_unx(const char *path)
{
	int i;
	for (i = 0; unx_trans[i].unx; i++)
		if (!strcmp(path, unx_trans[i].unx))
			return unx_trans[i].spd;
	return path;
}

#define data_alloc(bytes_len, align)					\
do {									\
	data_ptr = (data_ptr + (align) - 1) & ~(unsigned long)((align) - 1); \
	if (__unlikely(data_ptr + (bytes_len) > data_size)) goto moresize; \
	ptr = data + data_ptr;						\
	data_ptr += (bytes_len);					\
} while (0)

#define data_write(bytes, bytes_len, align)				\
do {									\
	size_t bl_ = (bytes_len);					\
	data_alloc(bl_, align);						\
	memcpy(ptr, (bytes), bl_);					\
} while (0)

struct exec_data {
	unsigned long size;
	char *exe;
	char **argv;
	int n_argv;
	char **env;
	int n_env;
	char *wd;
	FFILE **handles;
	int n_handles;
	VMMAP *vmmaps;
	int n_vmmaps;
	VMMAP *vmmaps_back;
	LNT *lnt;
};

#include <LIB/KERNEL/UEXEC.I>

int execve(const char *path, char *const argv[], char *const envp[])
{
	sigset_t sigs;
#define xdata	((struct exec_data *)data)
	char **narg;
	unsigned long data_size, data_ptr;
	void *ptr;
	char **en;
	char *data;
	int n, hn;
	char *p;
	char *pwd, *pwdx;
	LNTE *lnte;
	char jobn[9];
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_ZERO)))
		KERNEL$SUICIDE("execve AT SPL %08X", KERNEL$SPL);
#endif
	sigfillset(&sigs);
	sigprocmask(SIG_BLOCK, &sigs, &sigs);
	jobn[0] = 0;
	KERNEL$PROC_GET_JOB_NAME(jobn);
	if (__unlikely(jobn[0])) {
		/* dash needs this when executing line cat << EOF | cat */
		int r;
		do_transparent_fork:
		if ((r = transparent_fork())) goto ret__1;
	}
	RAISE_SPL(SPL_BOTTOM);
	for (n = 0; n < udata.n_handles; n++) {
		int fl = KERNEL$HANDLE_FLAGS(n);
		if (__unlikely(fl != -1)) {
			if ((fl & (_O_PIPE | _O_KRNL_FORKED)) == _O_PIPE) {
				LOWER_SPL(SPL_ZERO);
				goto do_transparent_fork;
			}
		}
	}
	if (__likely((pwdx = KERNEL$GET_CWD(KERNEL$CWD())) != NULL)) {
		unsigned long l = strlen(pwdx) + 1;
		pwd = alloca(l);
		memcpy(pwd, pwdx, l);
	} else {
		pwd = NULL;
	}
	LOWER_SPL(SPL_ZERO);
	if (__unlikely(path[0] == '/') && __unlikely(path[1] == 'b') && __likely(path[2] == 'i') && __likely(path[3] == 'n') && __likely(path[4] == '/')) path = translate_unx(path);
	p = (char *)path;
	if (__unlikely(is_cmd(path))) {
		int i;
		cmd:
		for (i = 0; argv[i]; i++) ;
		narg = alloca((i + 4) * sizeof(char *));
		narg[0] = "LIB.:/SHELL.EXE";
		narg[1] = "CALL";
		narg[2] = p;
		if (__likely(i)) memcpy(narg + 3, argv + 1, i * sizeof(char *));
		else narg[3] = NULL;
		if (__unlikely(!is_exec(narg[0]))) goto ret__1;
		p = narg[0];
		argv = narg;
		goto ok;
	}
	if (__unlikely(!is_exec(p))) {
		/* This should be consistent with access_exec */
		int e;
		char *q = strrchr(p, '.');
		if (q) if (__unlikely(!_strcasecmp(q, ".EXE")) || __unlikely(!_strcasecmp(q, ".CMD"))) goto ret__1;
		e = errno;
		p = alloca(strlen(path) + 5);
		if (__unlikely(!p)) goto ret__1;
		stpcpy(stpcpy(p, path), ".EXE");
		if (is_exec(p)) goto ok;
		stpcpy(stpcpy(p, path), ".CMD");
		if (__unlikely(!is_cmd(p))) {
			if (e == ENOEXEC || errno == ENOENT) errno = e;
			goto ret__1;
		}
		goto cmd;
	}
	ok:
	if (__unlikely(SUBPROC_CTL != NULL)) LIBPROC_CLEANUP(1);	/* raises SPL */
	LOWER_SPL(SPL_ZERO);
	data_size = PAGE_CLUSTER_SIZE;
	if (0) {
		moresize:
		LOWER_SPL(SPL_ZERO);
		munmap(data, data_size);
		if (__unlikely(!(data_size <<= 1))) {
			errno = ENOMEM;
			goto ret__1;
		}
	}
	if (__unlikely((data = mmap(NULL, data_size, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS | MAP_INHERIT, -1, 0)) == MAP_FAILED)) goto ret__1;
	if (0) {
		cloexec:
		LOWER_SPL(SPL_ZERO);
		close(n);
	}
	data_ptr = sizeof(struct exec_data);

	RAISE_SPL(SPL_TOP);

	for (n = 0; n < udata.n_handles; n++) {
		if (__unlikely((int)(unsigned long)udata.handles[n] & FD_CLOEXEC)) goto cloexec;
	}

	xdata->size = data_size;
	data_write(p, strlen(p) + 1, 1);
	xdata->exe = ptr;
	for (n = 0; argv[n]; n++) ;
	xdata->n_argv = n;
	data_alloc(n * sizeof(char *), sizeof(char *));
	xdata->argv = ptr;
	for (n = 0; argv[n]; n++) {
		data_write(argv[n], strlen(argv[n]) + 1, 1);
		xdata->argv[n] = ptr;
	}
	if (__likely(!envp)) en = environ;
	else en = (char **)envp;
	if (__likely(en != NULL)) {
		for (n = 0; en[n]; n++) ;
		xdata->n_env = n;
		data_alloc(n * sizeof(char *), sizeof(char *));
		xdata->env = ptr;
		for (n = 0; en[n]; n++) {
			data_write(en[n], strlen(en[n]) + 1, 1);
			xdata->env[n] = ptr;
		}
	}
	if (__likely(pwd != NULL)) {
		data_write(pwd, strlen(pwd) + 1, 1);
		xdata->wd = ptr;
	}

	hn = POSIX_RESERVED_HANDLES;
	for (n = 0; n < udata.n_handles; n++) if (__unlikely(udata.handles[n] != NULL)) {
		hn = n + 1;
	}
	xdata->n_handles = hn;
	data_alloc(hn * sizeof(FFILE *), sizeof(FFILE *));
	xdata->handles = ptr;
	for (n = 0; n < hn; n++) if (__unlikely(udata.handles[n] != NULL)) {
		FFILE *f;
		data_write(udata.handles[n], (unsigned long)((FFILE *)NULL)->path + strlen(udata.handles[n]->path) + 1, sizeof(off_t));
		f = xdata->handles[n] = ptr;
		if ((__unlikely((f->flags & (_O_PIPE | _O_KRNL_FORKED)) == _O_PIPE))) f->pos = 0;	/* if pipe is created and process execs, pipe is closed --- there is no one to control the pipe anyway */
	}
	data_alloc(0, sizeof(off_t));
	xdata->vmmaps = ptr;
	hn = 0;
	for (n = 0; n < udata.n_vmmaps; n++) if (__unlikely(udata.vmmaps[n].flags & MAP_INHERIT)) {
		data_write(&udata.vmmaps[n], sizeof(VMMAP), 1);
		hn++;
	}
	xdata->n_vmmaps = hn;
	/* two mallocs for vmmap itself can increse number of maps by 2 */
	data_alloc(sizeof(VMMAP) * 2, 1);
	data_alloc(sizeof(VMMAP) * (hn + 3), 1);
	xdata->vmmaps_back = ptr;
	/* not needed --- we handle recursive mmap call
	if (__unlikely(hn * sizeof(VMMAP) >= PAGE_CLUSTER_SIZE / 2)) {
		errno = ENOMEM;
		LOWER_SPL(SPL_ZERO);
		munmap(data, data_size);
		goto ret__1;
	}*/
	data_alloc(sizeof(LNT), sizeof(unsigned long));
	xdata->lnt = ptr;
	for (n = 0; n < LNT_HASH_SIZE; n++) INIT_XLIST(&xdata->lnt->hash[n]);
	for (n = 0; n < LNT_HASH_SIZE; n++) XLIST_FOR_EACH_UNLIKELY(lnte, &LN->hash[n], LNTE, hash) if (__likely(!(lnte->handle & LNTE_DEVICE))) {
		LNTE *llnte;
		data_write(lnte, (unsigned long)((LNTE *)NULL)->name + strlen(lnte->name) + 1, sizeof(unsigned long));
		llnte = ptr;
		ADD_TO_XLIST(&xdata->lnt->hash[n], &llnte->hash);
	}

	ARCH_PREPARE_EXEC;	/* point of no return */
	return 0;
	ret__1:
	sigprocmask(SIG_SETMASK, &sigs, NULL);
	return -1;
#undef xdata
}

static void touchmap(VMMAP *vmmap)
{
	volatile char *v;
	char *e = (char *)vmmap->vmaddr + vmmap->vmsize;
	if (__unlikely(e < (char *)KERNEL$STACKPAGE)) for (v = vmmap->vmaddr; v < e; v += PAGE_CLUSTER_SIZE) *v = *v;
}

extern const char *__progname;
extern void (*__exit_func)(int);

void CONT_EXEC(struct exec_data *xdata);
void CONT_EXEC(struct exec_data *xdata)
{
	int i, n;
	char *lastptr;
	char **argv;
	FFILE **handles;
	VMMAP *vmmaps, *vmmaps_b;
	LNT *lnt;
	LNTE *lnte;
	START_ARG start;
	long ret;
	SYSCALL1(SYS_CANCEL_ALL);
	LN = xdata->lnt;
	udata.n_handles = xdata->n_handles;
	__barrier();
	udata.handles = xdata->handles;
	for (i = 0; i < udata.n_handles; i++) if (__unlikely(udata.handles[i] != NULL)) SYSCALL2(SYS_FAST_CLOSE, i);
	SET_VMMAPS(xdata->vmmaps, xdata->n_vmmaps);
	udata.vmmaps_b = xdata->vmmaps_back;
	lastptr = NULL;
	for (i = 0; i < udata.n_vmmaps; i++) {
		int flags;
		if (lastptr < (char *)udata.vmmaps[i].vmaddr) SYSCALL3(SYS_UNMAP_DEALLOC_RANGE, (unsigned long)lastptr, (char *)udata.vmmaps[i].vmaddr - lastptr);
		flags = udata.vmmaps[i].flags;
		if (__unlikely(flags & MAP_ANONYMOUS)) {
			touchmap(&udata.vmmaps[i]);
		} else if (__unlikely((flags & (MAP_ANONYMOUS | MAP_PRIVATE | __PROT_WRITTEN)) == (MAP_PRIVATE | __PROT_WRITTEN)) && __unlikely((unsigned long)udata.vmmaps[i].vmaddr != KERNEL_DLL_BASE)) {
			udata.vmmaps[i].flags |= PROT_READ | PROT_WRITE;
			touchmap(&udata.vmmaps[i]);
			udata.vmmaps[i].flags = flags;
		}
		lastptr = (char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize;
	}
	SYSCALL1(SYS_EXEC);
	udata.xcpt_available = 0;
	udata.timer_available = 0;
	__barrier();
	__CLEAR_ASTS(KERNEL$AST_QUEUES, KERNEL$AST_QUEUES);
	KERNEL$PPL = 0;
	memset((char *)&udata + UDATA_ZERO_EXEC_OFFSET, 0, UDATA_ZERO_EXEC_END_OFFSET - UDATA_ZERO_EXEC_OFFSET);
	ARCH_SET_EXEC_UDATA;
	LOWER_SPL(SPL_ZERO);

	udata.heap_freelist = (void *)((((unsigned long)KERNEL$STACKPAGE + UDATA_TOP + sizeof(size_t) + __MALLOC_ALIGN - 1) & ~(unsigned long)(__MALLOC_ALIGN - 1)) - sizeof(size_t));
	((HEAP_FREELIST_T *)udata.heap_freelist)->size = (PAGE_CLUSTER_SIZE * UPAGES - sizeof(size_t) - ((unsigned long)udata.heap_freelist & (PAGE_CLUSTER_SIZE - 1))) & ~(size_t)(__MALLOC_ALIGN - 1);
	((HEAP_FREELIST_T *)udata.heap_freelist)->next = NULL;
	SLAB_ZERO_PREINIT();
	SLAB_INIT();
	KERNEL$PHYSICAL.op = &VIRTUAL_OPERATIONS;

	__DL_USER_INIT(2);

	/* these two mallocs can increase number of maps by 2 ---> +2 and +3 */
	udata.malloc_recurse = 1;
	if (__unlikely(!(vmmaps = malloc((xdata->n_vmmaps + 2) * sizeof(VMMAP))))) goto cantalloc;
	udata.malloc_recurse = 1;
	if (__unlikely(!(vmmaps_b = malloc((xdata->n_vmmaps + 3) * sizeof(VMMAP))))) goto cantalloc;
	udata.malloc_recurse = 0;
	memcpy(vmmaps, udata.vmmaps, udata.n_vmmaps * sizeof(VMMAP));
	SET_VMMAPS(vmmaps, udata.n_vmmaps);
	udata.vmmaps_b = vmmaps_b;

	UIO_RST_INIT();		/* must be before timer */
	KTIMER_INIT();
	if (__unlikely(!(__progname = malloc(strlen(xdata->exe) + 1)))) goto cantalloc;
	strcpy((char *)__progname, xdata->exe);
	if (__unlikely(!(argv = malloc((xdata->n_argv + 1) * sizeof(char *))) != NULL)) goto cantalloc;
	for (i = 0; i < xdata->n_argv; i++) {
		if (__unlikely(!(argv[i] = malloc(strlen(xdata->argv[i]) + 1)))) goto cantalloc;
		strcpy(argv[i], xdata->argv[i]);
	}
	argv[i] = NULL;
	ENV_INIT();
	environ = NULL;
	/*if (__unlikely(!(environ = malloc((xdata->n_env + 1) * sizeof(char *))))) goto cantalloc;*/
	for (i = 0; i < xdata->n_env; i++) {
		putenv(xdata->env[i]);
		/*if (__unlikely(!(environ[i] = malloc(strlen(xdata->env[i]) + 1)))) goto cantalloc;
		strcpy(environ[i], xdata->env[i]);*/
	}
	/*environ[i] = NULL;*/
	if (__likely(xdata->wd != NULL)) {
		if (__unlikely(!(udata.cwd = malloc(strlen(xdata->wd) + 1)))) goto cantalloc;
		strcpy(udata.cwd, xdata->wd);
	}

	n = 1;
	while (n < xdata->n_handles) n <<= 1;
	if (__unlikely(!(handles = malloc(n * sizeof(FFILE *)))) && __unlikely(n)) goto cantalloc;
	memset(handles, 0, n * sizeof(FFILE *));
	for (i = 0; i < xdata->n_handles; i++) if (__likely(xdata->handles[i] != NULL)) {
		unsigned long l = (unsigned long)((FFILE *)NULL)->path + strlen(xdata->handles[i]->path) + 1;
		FFILE *f = malloc(l);
		if (__unlikely(!f)) goto cantalloc;
		memcpy(f, xdata->handles[i], l);
		handles[i] = f;
	}
	__barrier();
	udata.handles = handles;
	__barrier();
	udata.n_handles = n;
	for (i = 0; i < udata.n_handles; i++) if (__unlikely(udata.handles[i] != NULL)) SYSCALL2(SYS_FAST_CLOSE, i);

	if (__unlikely(!(lnt = malloc(sizeof(LNT))) != NULL)) goto cantalloc;
	for (i = 0; i < LNT_HASH_SIZE; i++) INIT_XLIST(&lnt->hash[i]);
	for (i = 0; i < LNT_HASH_SIZE; i++) XLIST_FOR_EACH_UNLIKELY(lnte, &xdata->lnt->hash[i], LNTE, hash) {
		unsigned long l = (unsigned long)((LNTE *)NULL)->name + strlen(lnte->name) + 1;
		LNTE *llnte = malloc(l);
		if (__unlikely(!llnte)) goto cantalloc;
		memcpy(llnte, lnte, l);
		ADD_TO_XLIST(&lnt->hash[i], &lnte->hash);
	}
	__barrier();
	LN = lnt;
	__barrier();
	munmap(xdata, xdata->size);
	THREAD_INIT();
	SIGNAL_INIT();
	start.argv = (const char * const *)argv;
	start.env = environ;
	ret = __DL_USER_LOAD_EXE(__progname, &start, &udata.dl_exe);
	if (__likely(__exit_func != NULL)) __exit_func(ret);
	_exit(ret);
	cantalloc:
	__critical_printf("CAN'T ALLOCATE STRUCTURES AFTER EXEC");
	_exit(255);
}

static int transparent_fork(void)
{
	pid_t new;
	char *shared;
	shared = mmap(NULL, 1, PROT_READ | PROT_WRITE, MAP_ANONYMOUS | MAP_SHARED, -1, 0);
	if (__unlikely(shared == MAP_FAILED)) return -1;
	*shared = 0;
	new = fork();
	if (__unlikely(new < 0)) return -1;
	if (new) {
		pid_t w;
		int status;
		int ret_status = 0;
		int exit_code;
		/* stop other threads */
		THREAD_FORK();
		fake_close_all();
		*shared = 1;
		munmap(shared, 1);
		while ((w = wait(&status)) >= 0) {
			if (w == new) ret_status = status;
		}
		if (WTERMSIG(ret_status)) exit_code = __EXIT_SIGNAL(WTERMSIG(ret_status));
		else exit_code = WEXITSTATUS(ret_status);
		_exit(exit_code);
	}
	while (!*shared) KERNEL$SLEEP(1);
	munmap(shared, 1);
	return 0;
}
