#ifndef __LIB_KERNEL_UIO_H
#define __LIB_KERNEL_UIO_H

#include <SPAD/DEV_KRNL.H>
#include <LIB/KERNEL/UASM.H>

void UIO_INIT(void);
void UIO_DUPSTD(void);
void UIO_RST_INIT(void);

#define HANDLE_PTR(i)	((FFILE *)((unsigned long)udata.handles[i] & ~1UL))

void fake_close_all(void);
int _dup_noposix_unlocked(int h);
void _close_unlocked(int h);

int UIO_MAKE_FORKTABLE(FFILE ***forktable, int *forktable_n);
void UIO_FREE_FORKTABLE(FFILE **forktable, int forktable_n);
void UIO_FORK(void);
void UIO_CLEANUP(int status);

off_t UIO_TRY_FASTSEEK(int h, off_t offset, int whence);

int UVM_SAVE_FAULT(void *a, int err);

int SIGCHLD_FOR_STOPPED(void);

void drain_pty(void);

#endif
