#include <SPAD/AC.H>
#include <FCNTL.H>
#include <UNISTD.H>
#include <ERRNO.H>
#include <SYS/IOCTL.H>
#include <LIB/KERNEL/UIO.H>

#include <PTY.H>

#define MASTER_STRING	"SYS$SWAPPER:/^PTYP"
#define MASTER_STRING_LEN	18
#define SLAVE_STRING	"SYS$SWAPPER:/^TTYP"
#define SLAVE_STRING_LEN	18

static char pty_used = 0;

int openpty(int *amaster, int *aslave, char *name, struct termios *termi, struct winsize *wins)
{
	int spl;
	int i;
	int master, slave;
#if __DEBUG >= 2
	if (__unlikely(MASTER_STRING_LEN != strlen(MASTER_STRING)))
		KERNEL$SUICIDE("openpty: BAD MASTER_STRING_LEN: %d != %d", MASTER_STRING_LEN, (int)strlen(MASTER_STRING));
	if (__unlikely(SLAVE_STRING_LEN != strlen(SLAVE_STRING)))
		KERNEL$SUICIDE("openpty: BAD SLAVE_STRING_LEN: %d != %d", SLAVE_STRING_LEN, (int)strlen(SLAVE_STRING));
#endif
	master = open(MASTER_STRING, O_RDWR);
	if (__unlikely(master < 0)) return -1;
	slave = open(SLAVE_STRING, O_RDWR);
	if (__unlikely(slave < 0)) {
		cl_master:
		close(master);
		return -1;
	}
	spl = KERNEL$SPL;
	RAISE_SPL(SPL_DEV);
	for (i = 0; i < udata.n_handles; i++) {
		FFILE *f;
		if (!(f = HANDLE_PTR(i))) continue;
		if (__unlikely(i == master) || __unlikely(i == slave)) continue;
		if ((__unlikely(!memcmp(f->path, MASTER_STRING, MASTER_STRING_LEN)) && (!f->path[MASTER_STRING_LEN] || f->path[MASTER_STRING_LEN] == '/')) ||
		    (__unlikely(!memcmp(f->path, SLAVE_STRING, SLAVE_STRING_LEN)) && (!f->path[SLAVE_STRING_LEN] || f->path[SLAVE_STRING_LEN] == '/'))) {
			LOWER_SPLX(spl);
			errno = EEXIST;
			cl_slave:
			close(slave);
			goto cl_master;
		}
	}
	LOWER_SPLX(spl);
	if (termi) {
		if (__unlikely(ioctl(slave, TIOCSETA, termi))) goto cl_slave;
	}
	if (wins) {
		if (__unlikely(ioctl(slave, TIOCSWINSZ, wins))) goto cl_slave;
	}
	if (__unlikely(name != NULL)) {
		strcpy(name, SLAVE_STRING);
	}
	*amaster = master;
	*aslave = slave;
	pty_used = 1;
	return 0;
}

int login_tty(int h)
{
	if (dup2(h, 0) < 0) return -1;
	dup2(h, 1);
	dup2(h, 2);
	if (__likely(h > 2)) close(h);
	return 0;
}

pid_t forkpty(int *amaster, char *name, struct termios *termi, struct winsize *wins)
{
	int master, slave;
	pid_t pid;
	if (__unlikely(openpty(&master, &slave, name, termi, wins) < 0)) {
		return -1;
	}
	pid = fork();
	if (__unlikely(pid < 0)) {
		close(master);
		close(slave);
		return -1;
	}
	if (!pid) {
		close(master);
		if (__unlikely(login_tty(slave) < 0)) _exit(1);
		return 0;
	}
	*amaster = master;
	close(slave);
	return pid;
}

void drain_pty(void)
{
	static char drain_buffer[16];
	int master;
	if (__likely(!pty_used)) return;
	master = open(MASTER_STRING, O_RDWR | O_NONBLOCK);
	if (__unlikely(master < 0)) return;
	while (read(master, drain_buffer, sizeof drain_buffer) > 0) ;
	close(master);
}
