#include <SPAD/DEV.H>
#include <SPAD/RANDOM.H>
#include <KERNEL/RANDOM.H>
#include <STRING.H>

static int h = -1;
static int in_progress = 0;
static char buffer[128];

static union {
	OPENRQ openrq;
	SIORQ siorq;
} u;

static DECL_AST(open_done, SPL_TOP, OPENRQ)
{
	if (__likely(RQ->status >= 0)) h = RQ->status;
	in_progress = 0;
	RETURN;
}

static DECL_AST(write_done, SPL_TOP, SIORQ)
{
	in_progress = 0;
	RETURN;
}

void urandom_add_data(RANDOM_CTX *ctx, void *ptr, int len)
{
	int l;
	int spl = KERNEL$SPL;
	again:
	RAISE_SPL(SPL_TOP);
	if (in_progress) {
		ret:
		LOWER_SPLX(spl);
		return;
	}
	if (__unlikely(h == -1)) {
		in_progress = 1;
		u.openrq.fn = open_done;
		u.openrq.flags = O_WRONLY;
		u.openrq.path = "SYS$RANDOM:/";
		u.openrq.cwd = NULL;
		CALL_IORQ(&u.openrq, KERNEL$OPEN);
		goto ret;
	}
	in_progress = 1;
	l = len > sizeof(buffer) ? sizeof(buffer) : len;
	memcpy(buffer, ptr, l);
	ptr = (char *)ptr + l;
	len -= l;
	u.siorq.fn = write_done;
	u.siorq.h = h;
	u.siorq.v.ptr = (unsigned long)buffer;
	u.siorq.v.len = l;
	u.siorq.v.vspace = &KERNEL$VIRTUAL;
	u.siorq.progress = 0;
	CALL_IORQ(&u.siorq, KERNEL$WRITE);
	LOWER_SPLX(spl);
	if (len && !in_progress) goto again;
}
