#include <KERNEL/DEV.H>
#include <KERNEL/VM.H>
#include <SYS/MMAN.H>
#include <KERNEL/UDATA.H>
#include <LIB/KERNEL/UASM.H>
#include <LIB/KERNEL/UIO.H>
#include <KERNEL/SYSCALL.H>
#include <STRING.H>
#include <STDLIB.H>
#include <STDARG.H>
#include <UNISTD.H>
#include <SPAD/IOCTL.H>
#include <SPAD/SYNC.H>
#include <SPAD/DEV.H>
#include <KERNEL/SLAB.H>

USER_SIZE_DESC *USER_SIZE_DESCS = NULL;
PAGE *USER_PAGE_DESCS = NULL;

WQ_DECL(KERNEL$FREEMEM_WAIT, "KERNEL$FREEMEM_WAIT");

#define vmmap_joinable(predict, addr1, length1, offset1, handle1, flags1, err1, addr2, length2, offset2, handle2, flags2, err2)				\
	__likely(!(err1 | err2)) &&					\
	(predict((char *)(addr1) + (length1) == (char *)(addr2)) &&	\
	predict((flags1) == (flags2)) &&				\
	__likely(!((flags1) & _MAP_NOFAULT)) &&				\
	(predict((flags1) & MAP_ANONYMOUS) || ((handle1) == (handle2) && (offset1) + (length1) == (offset2))))

	/* the lock must be reentrant */
#define LOCK_MMAP	spl = KERNEL$SPL; RAISE_SPL(SPL_MALLOC)
#define UNLOCK_MMAP	LOWER_SPLX(spl)

/*
void dump_map()
{
	int i;
__debug_printf("vmmaps(%d<%d;%d<%d): ",udata.n_vmmaps * sizeof(VMMAP), __alloc_size(udata.vmmaps), (udata.n_vmmaps + 1) * sizeof(VMMAP), __alloc_size(udata.vmmaps_b));
	for (i = 0; i < udata.n_vmmaps; i++) __debug_printf("(A %p, S %d, F %x, H %d(%s), O %Ld)", udata.vmmaps[i].vmaddr, udata.vmmaps[i].vmsize, udata.vmmaps[i].flags, udata.vmmaps[i].handle, udata.vmmaps[i].handle != -1 ? KERNEL$HANDLE_PATH(udata.vmmaps[i].handle) : "-", udata.vmmaps[i].offset);
	__debug_printf("\n");
}
*/

static int test_mmap(int h, int flags)
{
	IOCTLRQ io;
	io.h = h;
	io.ioctl = IOCTL_CAN_MMAP;
	io.param = (flags & (MAP_SHARED | PROT_WRITE)) == (MAP_SHARED | PROT_WRITE);
	io.v.ptr = 0;
	io.v.len = 0;
	io.v.vspace = &KERNEL$VIRTUAL;
	SYNC_IO(&io, KERNEL$IOCTL);
	if (__unlikely(io.status != 0)) {
		if (io.status == -ENOOP) errno = ENODEV;
		else errno = -io.status;
		return -1;
	}
	return 0;
}

void *mmap(void *start, size_t length, int prot, int orig_flags, int h, off_t offset)
{
	VMMAP *v, *vv;
	int nvm;
	void *sstart;
	int spl;
	int i;
	int hd = 0;
	int flags = orig_flags | prot;
	int set_flags;
	int err;
	/*__debug_printf("starting mmap (%d)\n", udata.malloc_recurse);*/
	if (__unlikely(!(flags & MAP_ANONYMOUS))) {
		if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), KERNEL$SPL))) goto badspl;
		if (__unlikely(flags & _MAP_IMMEDIATE)) {
			flags &= ~_MAP_IMMEDIATE;
			goto skip_test;
		}
		if (__unlikely(test_mmap(h, flags))) return MAP_FAILED;
		skip_test:;
	} else {
		if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), KERNEL$SPL)))
			badspl: KERNEL$SUICIDE("mmap AT SPL %08X", KERNEL$SPL);
		flags &= ~_MAP_IMMEDIATE;
		if (MAP_SHARED < PROT_READ) flags |= ((unsigned)flags & MAP_SHARED) * (PROT_READ / MAP_SHARED);
		else flags |= ((unsigned)flags & MAP_SHARED) / (MAP_SHARED < PROT_READ ? 1 : MAP_SHARED / PROT_READ);
		h = -1;
		offset = 0;
	}
	/*__debug_printf("mmap(%p,%x,%x,%x,%s,%Lx)\n", start, length, prot, flags, h != -1 ? KERNEL$HANDLE_PATH(h) : "-", offset);*/
	if (MAP_PRIVATE > MAP_SHARED) {
		if (__unlikely(((unsigned)flags ^ MAP_PRIVATE ^ ((unsigned)flags * (MAP_PRIVATE / MAP_SHARED))) & MAP_PRIVATE)) goto einval;
	} else {
		if (__unlikely(((unsigned)flags ^ MAP_SHARED ^ ((unsigned)flags * (MAP_SHARED / MAP_PRIVATE))) & MAP_SHARED)) goto einval;
	}
	if (__likely(flags & (PROT_WRITE | _MAP_NODEALLOC))) flags |= __PROT_WRITTEN;
	if (__unlikely(!length)) return start;
	length = (length + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
	if (__unlikely(!length)) goto einval;
	if (__unlikely(((int)(unsigned long)start | (int)offset) & (PAGE_CLUSTER_SIZE - 1))) {
		if (__unlikely((int)offset & (PAGE_CLUSTER_SIZE - 1))) {
			einval:
			err = -EINVAL;
			ret_error:
			if (!(orig_flags & _MAP_IMMEDIATE)) {
				errno = -err;
				return MAP_FAILED;
			} else {
				return __ERR_PTR(err);
			}
		}
		if (__unlikely(flags & MAP_FIXED)) goto einval;
		start = (void *)(((unsigned long)start + PAGE_CLUSTER_SIZE - 1) & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
	}
	if (__unlikely(udata.malloc_recurse)) {
/* note: when recursing, mmap MUST always swap vmmaps and vmmaps_b */
		if (__unlikely(udata.malloc_recurse == 2)) KERNEL$SUICIDE("mmap: DOUBLE CALL TO mmap FROM malloc");
		udata.malloc_recurse = 2;
	}
	map_lock_repeat:
	LOCK_MMAP;
	if (__unlikely(!(flags & MAP_ANONYMOUS)) && (__unlikely((unsigned)h >= udata.n_handles) || __unlikely(!udata.handles[h]))) {
		if (hd) _close_unlocked(h);
		UNLOCK_MMAP;
		err = -EBADF;
		goto ret_error;
	}
	if (__unlikely(!(flags & MAP_ANONYMOUS)) && !hd) {
		for (i = 0; i < udata.n_vmmaps; i++) if (HANDLE_PTR(udata.vmmaps[i].handle) == HANDLE_PTR(h) && (((flags & (MAP_FIXED | _MAP_NOUNMAP)) != MAP_FIXED) || udata.vmmaps[i].vmaddr < start || ((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize) > (char *)start + length)) {
			h = udata.vmmaps[i].handle;
			if (__unlikely(flags & MAP_INHERIT)) fcntl(h, F_SETFD, 0);
			goto goth;
		}
		h = _dup_noposix_unlocked(h);
		if (__unlikely(h < 0)) {
			UNLOCK_MMAP;
			err = h;
			goto ret_error;
		}
		hd = 1;
		if (__likely(!(flags & MAP_INHERIT))) fcntl(h, F_SETFD, FD_CLOEXEC);
		goth:;
	}
	alloc_again:
	sstart = start;
	search_again:
	if (__likely(!sstart) && __likely(!(flags & MAP_FIXED))) sstart = (void *)KERNEL_DLL_BASE;
	for (i = 0; i < udata.n_vmmaps; i++) {
		if (__unlikely((char *)udata.vmmaps[i].vmaddr >= (char *)sstart + length)) goto found;
		if (__likely((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize > (char *)sstart)) {
			if (__unlikely(flags & MAP_FIXED)) {
				if (__unlikely(!(flags & _MAP_NOUNMAP))) {
					if (udata.vmmaps[i].vmaddr == start) {
						int j;
						for (j = i; j < udata.n_vmmaps; j++) {
							if (__likely((char *)udata.vmmaps[j].vmaddr + udata.vmmaps[j].vmsize == (char *)start + length)) {
								memcpy(udata.vmmaps_b, udata.vmmaps, i * sizeof(VMMAP));
								udata.vmmaps_b[i].vmaddr = start;
								udata.vmmaps_b[i].vmsize = length;
								udata.vmmaps_b[i].offset = offset;
								udata.vmmaps_b[i].handle = h;
								udata.vmmaps_b[i].flags = flags & ~(MAP_FIXED | _MAP_NODEALLOC);
								udata.vmmaps_b[i].error = 0;
								memcpy(udata.vmmaps_b + i + 1, udata.vmmaps + j + 1, (udata.n_vmmaps - j - 1) * sizeof(VMMAP));
								nvm = udata.n_vmmaps - (j - i);
								set_flags = MAP_FIXED;
								goto swap_vmmaps;
							}
							if ((char *)udata.vmmaps[j].vmaddr + udata.vmmaps[j].vmsize > (char *)start + length) break;
						}
					}
					UNLOCK_MMAP;
					/*munmap(start, length);*/
					mprotect(start, length, -1);
					/*__debug_printf("x: %p, %x\n", start, length);*/
					goto map_lock_repeat;
				}
				if (hd) _close_unlocked(h), hd = 0;
				UNLOCK_MMAP;
				goto einval;
			}
			sstart = (char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize;
		}
	}
	found:
	if (__unlikely((unsigned long)sstart > KERNEL$STACKPAGE) || __unlikely((unsigned long)sstart + length > KERNEL$STACKPAGE)) {
		if (__unlikely(flags & MAP_FIXED)) {
			if (hd) _close_unlocked(h);
			UNLOCK_MMAP;
			goto einval;
		}
		if (__likely(start != NULL)) {
			sstart = NULL;
			start = NULL;
			goto search_again;
		}
		if (hd) _close_unlocked(h);
		UNLOCK_MMAP;
		err = -ENOMEM;
		goto ret_error;
	}
	set_flags = flags & ~(MAP_FIXED | _MAP_NOUNMAP | _MAP_NODEALLOC);
	if (__likely(i) && vmmap_joinable(__likely, udata.vmmaps[i - 1].vmaddr, udata.vmmaps[i - 1].vmsize, udata.vmmaps[i - 1].offset, udata.vmmaps[i - 1].handle, udata.vmmaps[i - 1].flags, udata.vmmaps[i - 1].error, sstart, length, offset, h, set_flags, 0)) {
		/*__debug_printf("JOIN 1");*/
		udata.vmmaps[i - 1].vmsize += length;
		if (__likely(i != udata.n_vmmaps) && vmmap_joinable(__unlikely, sstart, length, offset, h, set_flags, 0, udata.vmmaps[i].vmaddr, udata.vmmaps[i].vmsize, udata.vmmaps[i].offset, udata.vmmaps[i].handle, udata.vmmaps[i].flags, udata.vmmaps[i].error)) {
		/*__debug_printf("JOIN 3");*/
			memcpy(udata.vmmaps_b, udata.vmmaps, i * sizeof(VMMAP));
			memcpy(udata.vmmaps_b + i, udata.vmmaps + i + 1, (udata.n_vmmaps - i - 1) * sizeof(VMMAP));
			udata.vmmaps_b[i - 1].vmsize += udata.vmmaps[i].vmsize;
			v = udata.vmmaps;
			SET_VMMAPS(udata.vmmaps_b, udata.n_vmmaps - 1);
			udata.vmmaps_b = v;
		} else if (__unlikely(udata.malloc_recurse)) {
			memcpy(udata.vmmaps_b, udata.vmmaps, udata.n_vmmaps * sizeof(VMMAP));
			v = udata.vmmaps;
			SET_VMMAPS(udata.vmmaps_b, udata.n_vmmaps);
			udata.vmmaps_b = v;
		}
		goto ret_success;
	}
	if (__likely(i != udata.n_vmmaps) && vmmap_joinable(__unlikely, sstart, length, offset, h, set_flags, 0, udata.vmmaps[i].vmaddr, udata.vmmaps[i].vmsize, udata.vmmaps[i].offset, udata.vmmaps[i].handle, udata.vmmaps[i].flags, udata.vmmaps[i].error)) {
		/*__debug_printf("JOIN 2");*/
		memcpy(udata.vmmaps_b, udata.vmmaps, udata.n_vmmaps * sizeof(VMMAP));
		udata.vmmaps_b[i].vmaddr = (char *)udata.vmmaps_b[i].vmaddr - length;
		udata.vmmaps_b[i].vmsize += length;
		if (!(set_flags & MAP_ANONYMOUS)) udata.vmmaps_b[i].offset -= length;
		nvm = udata.n_vmmaps;

		swap_vmmaps:
		if (__unlikely(udata.malloc_recurse) || __alloc_size(udata.vmmaps) >= (nvm + 1) * sizeof(VMMAP)) {
			vv = udata.vmmaps;
			SET_VMMAPS(udata.vmmaps_b, nvm);
			udata.vmmaps_b = vv;
		} else {
			/*__debug_printf("recursing...: %p,%p\n",udata.vmmaps, udata.vmmaps_b);*/
			udata.malloc_recurse = 1;
			v = malloc((udata.n_vmmaps + 2) * sizeof(VMMAP));
			if (__unlikely(!v)) {
				if (hd) _close_unlocked(h);
				udata.malloc_recurse = 0;
				UNLOCK_MMAP;
				err = -ENOMEM;
				goto ret_error;
			}
			if (__unlikely(udata.malloc_recurse == 2)) {
				/*__debug_printf("rec 2...: %p,%p\n",udata.vmmaps, udata.vmmaps_b);*/
				udata.malloc_recurse = 0;
				vv = udata.vmmaps_b;
				udata.vmmaps_b = v;
				free(vv);
				goto alloc_again;
			}
			udata.malloc_recurse = 0;
			vv = udata.vmmaps;
			SET_VMMAPS(udata.vmmaps_b, nvm);
			udata.vmmaps_b = v;
			free(vv);
		}
		if (__unlikely(set_flags & MAP_FIXED)) {	/* this is a dirty trick --- we get here with flags & MAP_FIXED only if we mapped over existing file. Otherwise flags &= ~(MAP_FIXED | _MAP_NOUNMAP) was done */
			if (__unlikely(flags & _MAP_NODEALLOC) && __likely(flags & (MAP_ANONYMOUS | MAP_PRIVATE))) SYSCALL3(SYS_UNMAP_RANGE, (unsigned long)sstart, (unsigned long)length);
			else SYSCALL3(SYS_UNMAP_RANGE + 1, (unsigned long)sstart, (unsigned long)length);
		}
		ret_success:
		if (__unlikely((flags & (MAP_ANONYMOUS | MAP_SHARED)) == (MAP_ANONYMOUS | MAP_SHARED))) {
			size_t i;
			for (i = 0; i < length; i += PAGE_CLUSTER_SIZE) *((volatile char *)sstart + i);
		}
		/*dump_map();*/
		UNLOCK_MMAP;
		/* !!! TODO: prefault page range */
	/*__debug_printf("mmap(h=%d,size=%d,offset=%Ld->%p)", h, length, offset, sstart);*/
		return sstart;
	}
	memcpy(udata.vmmaps_b, udata.vmmaps, i * sizeof(VMMAP));
	udata.vmmaps_b[i].vmaddr = sstart;
	udata.vmmaps_b[i].vmsize = length;
	udata.vmmaps_b[i].offset = offset;
	udata.vmmaps_b[i].handle = h;
	udata.vmmaps_b[i].flags = set_flags;
	udata.vmmaps_b[i].error = 0;
	memcpy(udata.vmmaps_b + i + 1, udata.vmmaps + i, (udata.n_vmmaps - i) * sizeof(VMMAP));
	nvm = udata.n_vmmaps + 1;
	goto swap_vmmaps;
}

int munmap(void *start, size_t length)
{
	VMMAP *v, *vv;
	int i, j;
	int spl;
	int free_swapper;
	/*__debug_printf("munmap: %p - %x\n", start, length);*/
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), KERNEL$SPL)))
		badspl: KERNEL$SUICIDE("munmap AT SPL %08X", KERNEL$SPL);
	length = (length + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
	if (__unlikely((int)(unsigned long)start & (PAGE_CLUSTER_SIZE - 1))) {
		if (KERNEL$SPL == SPL_X(SPL_ZERO)) errno = EINVAL;
		return -1;
	}
	if (__unlikely(!length)) return 0;
	LOCK_MMAP;
	free_again:
	free_swapper = 0;
	j = 0;
	for (i = 0; i < udata.n_vmmaps; i++) {
		int c;
		if ((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize <= (char *)start || (char *)udata.vmmaps[i].vmaddr >= (char *)start + length) {
			memcpy(&udata.vmmaps_b[j], &udata.vmmaps[i], sizeof(VMMAP));
			j++;
			continue;
		}
		if (udata.vmmaps[i].flags & __PROT_WRITTEN && (udata.vmmaps[i].flags & (MAP_SHARED | MAP_ANONYMOUS)) != MAP_SHARED) free_swapper = 1;
		c = 0;
		if (start > udata.vmmaps[i].vmaddr) {
			memcpy(&udata.vmmaps_b[j], &udata.vmmaps[i], sizeof(VMMAP));
			udata.vmmaps_b[j].vmsize = (char *)start - (char *)udata.vmmaps[i].vmaddr;
			j++;
			c = 1;
		}
		if ((char *)start + length < (char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize) {
			size_t sh = (char *)start + length - (char *)udata.vmmaps[i].vmaddr;
			memcpy(&udata.vmmaps_b[j], &udata.vmmaps[i], sizeof(VMMAP));
			udata.vmmaps_b[j].vmsize -= sh;
			if (!(udata.vmmaps_b[j].flags & MAP_ANONYMOUS)) udata.vmmaps_b[j].offset += sh;
			udata.vmmaps_b[j].vmaddr = (char *)udata.vmmaps_b[j].vmaddr + sh;
			j++;
			c = 1;
		}
		if (!c && __unlikely(udata.vmmaps[i].handle != -1)) {
			int k, h;
			if (__unlikely(SPLX_BELOW(SPL_X(SPL_DEV), spl))) goto badspl;
			h = udata.vmmaps[i].handle;
			for (k = 0; k < j; k++) if (__unlikely(udata.vmmaps_b[k].handle == h)) goto used;
			for (k = i + 1; k < udata.n_vmmaps; k++) if (__unlikely(udata.vmmaps[k].handle == h)) goto used;
			_close_unlocked(h);
			used:;
		}
	}
	if (__unlikely(j > udata.n_vmmaps)) {
		if (__unlikely(j > udata.n_vmmaps + 1))
			KERNEL$SUICIDE("munmap: TOO MANY SPLITS: j == %d, udata.n_vmmaps == %d", j, udata.n_vmmaps);
		if (__alloc_size(udata.vmmaps) >= j * sizeof(VMMAP) && __alloc_size(udata.vmmaps_b) >= (j + 1) * sizeof(VMMAP)) goto ok;
		udata.malloc_recurse = 1;
		v = malloc((j + 1) * sizeof(VMMAP));
		if (__unlikely(!v)) {
			udata.malloc_recurse = 0;
			UNLOCK_MMAP;
			if (KERNEL$SPL == SPL_X(SPL_ZERO)) errno = ENOMEM;
			return -1;
		}
		if (__unlikely(udata.malloc_recurse == 2)) {
			udata.malloc_recurse = 0;
			vv = udata.vmmaps_b;
			udata.vmmaps_b = v;
			free(vv);
			goto free_again;
		}
		udata.malloc_recurse = 0;
		SET_VMMAPS(udata.vmmaps_b, j);
		udata.vmmaps_b = v;
		goto done;
	}
	ok:
	v = udata.vmmaps;
	SET_VMMAPS(udata.vmmaps_b, j);
	memcpy(v, udata.vmmaps_b, j * sizeof(VMMAP));
	SET_VMMAPS(v, j);
	done:
	SYSCALL3(SYS_UNMAP_RANGE + free_swapper, (unsigned long)start, (unsigned long)length);
	/*dump_map();*/
	UNLOCK_MMAP;
	return 0;
}

int mprotect(void *start, size_t length, int prot)
{
#define join_with_previous if (__likely(prot != -1) && j && vmmap_joinable(__unlikely, v[j - 1].vmaddr, v[j - 1].vmsize, v[j - 1].offset, v[j - 1].handle, v[j - 1].flags, v[j - 1].error, v[j].vmaddr, v[j].vmsize, v[j].offset, v[j].handle, v[j].flags, v[j].error)) v[j - 1].vmsize += v[j].vmsize; else j++;
	VMMAP *v, *vv, *vvv;
	int i, j;
	int unmap;
	int spl;
	int err;

	if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), KERNEL$SPL)))
		KERNEL$SUICIDE("mprotect AT SPL %08X", KERNEL$SPL);
	if (__unlikely(prot & ~(PROT_READ | PROT_WRITE | PROT_EXEC | _MAP_IMMEDIATE))) {
		if (__unlikely(prot != -1)) {
			err = -EINVAL;
			ret_error:
			if (__likely(!(prot & _MAP_IMMEDIATE))) {
				errno = -err;
				return -1;
			} else {
				return err;
			}
		}
	}
	if (__unlikely(!length)) return 0;
	length += ((unsigned long)start & (PAGE_CLUSTER_SIZE - 1));
	start = (void *)((unsigned long)start & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
	length = (length + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
	if (prot & PROT_WRITE) prot |= __PROT_WRITTEN;
	v = malloc((udata.n_vmmaps + 2) * sizeof(VMMAP));
	if (__unlikely(!v)) {
		enomem:
		err = -ENOMEM;
		goto ret_error;
	}
	vv = malloc((udata.n_vmmaps + 3) * sizeof(VMMAP));
	if (__unlikely(!vv)) {
		free_v_enomem:
		free(v);
		goto enomem;
	}
	retry:
	LOCK_MMAP;
	if (__unlikely(__alloc_size(v) < (udata.n_vmmaps + 2) * sizeof(VMMAP))) {
		UNLOCK_MMAP;
		vvv = realloc(v, (udata.n_vmmaps + 2) * sizeof(VMMAP));
		if (__unlikely(!vvv)) {
			f_ret:
			free(vv);
			goto free_v_enomem;
		}
		v = vvv;
		goto retry;
	}
	if (__unlikely(__alloc_size(vv) < (udata.n_vmmaps + 3) * sizeof(VMMAP))) {
		UNLOCK_MMAP;
		vvv = realloc(vv, (udata.n_vmmaps + 3) * sizeof(VMMAP));
		if (__unlikely(!vvv)) goto f_ret;
		vv = vvv;
		goto retry;
	}
	unmap = 0;
	j = 0;
	for (i = 0; i < udata.n_vmmaps; i++) {
		int nf;
		if (i && (char *)start > (char *)udata.vmmaps[i - 1].vmaddr + udata.vmmaps[i - 1].vmsize && __unlikely(start < udata.vmmaps[i].vmaddr)) {
			unlock_efault:
			UNLOCK_MMAP;
			err = -EFAULT;
			goto ret_error;
		}
		if (i && (char *)start + length > (char *)udata.vmmaps[i - 1].vmaddr + udata.vmmaps[i - 1].vmsize && __unlikely((char *)start + length < (char *)udata.vmmaps[i].vmaddr)) goto unlock_efault;
		if ((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize <= (char *)start || (char *)udata.vmmaps[i].vmaddr >= (char *)start + length) {
			do_copy:
			memcpy(&v[j], &udata.vmmaps[i], sizeof(VMMAP));
			join_with_previous;
			/*j++;*/
			continue;
		}
		nf = (udata.vmmaps[i].flags & ~(PROT_READ | PROT_WRITE | PROT_EXEC)) | (prot & ~_MAP_IMMEDIATE);
		if (udata.vmmaps[i].flags & ~nf) unmap = 1;
		if (__unlikely(udata.vmmaps[i].flags == nf)) goto do_copy;
		if (__unlikely(prot == -1)) nf = udata.vmmaps[i].flags;
		if (start > udata.vmmaps[i].vmaddr) {
			size_t sh = (char *)start - (char *)udata.vmmaps[i].vmaddr;
			memcpy(&v[j], &udata.vmmaps[i], sizeof(VMMAP));
			v[j].vmsize = sh;
			j++;
			memcpy(&v[j], &udata.vmmaps[i], sizeof(VMMAP));
			v[j].vmaddr = start;
			v[j].vmsize -= sh;
			if (!(v[j].flags & MAP_ANONYMOUS)) v[j].offset += sh;
		} else {
			memcpy(&v[j], &udata.vmmaps[i], sizeof(VMMAP));
		}
		v[j].flags = nf;
		if ((char *)start + length < (char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize) {
			size_t sh = ((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize) - ((char *)start + length);
			v[j].vmsize -= sh;
			join_with_previous;
			/*j++;*/
			memcpy(&v[j], &udata.vmmaps[i], sizeof(VMMAP));
			v[j].vmaddr = (char *)start + length;
			v[j].vmsize = sh;
			if (!(v[j].flags & MAP_ANONYMOUS)) v[j].offset += udata.vmmaps[i].vmsize - sh;
		}
		join_with_previous;
		/*j++;*/
	}
	if (__unlikely(j > udata.n_vmmaps + 2))
		KERNEL$SUICIDE("mprotect: TOO MANY SPLITS: j == %d, udata.n_vmmaps == %d", j, udata.n_vmmaps);
	vvv = udata.vmmaps_b;
	udata.vmmaps_b = vv;
	vv = vvv;
	vvv = udata.vmmaps;
	SET_VMMAPS(v, j);
	v = vvv;
	if (unmap) SYSCALL3(SYS_UNMAP_RANGE, (unsigned long)start, (unsigned long)length);
	UNLOCK_MMAP;
	free(v);
	free(vv);
	return 0;
#undef join_with_previous
}

int msync(void *start, size_t length, int flags)
{
	int *array;
	int n_array;
	int h, i, r;
	int spl;
	__cancel_test();
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), KERNEL$SPL)))
		KERNEL$SUICIDE("msync AT SPL %08X", KERNEL$SPL);
	if (__unlikely(!length)) return 0;
	length += ((unsigned long)start & (PAGE_CLUSTER_SIZE - 1));
	start = (void *)((unsigned long)start & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
	length = (length + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);

	retry:
	array = malloc(udata.n_vmmaps * sizeof(int));
	if (__unlikely(!array)) return -1;
	LOCK_MMAP;
	if (__unlikely(__alloc_size(array) < sizeof(int) * udata.n_vmmaps)) {
		UNLOCK_MMAP;
		free(array);
		goto retry;
	}
	n_array = 0;
	for (i = 0; i < udata.n_vmmaps; i++) {
		if (__likely((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize <= (char *)start)) continue;
		else break;
	}
	for (; i < udata.n_vmmaps; i++) {
		if (__likely((char *)udata.vmmaps[i].vmaddr >= (char *)start + length)) break;
		if (__unlikely(!(udata.vmmaps[i].flags & __PROT_WRITTEN))) continue;
		if (__unlikely(udata.vmmaps[i].flags & (MAP_ANONYMOUS | MAP_PRIVATE))) continue;
		h = _dup_noposix_unlocked(udata.vmmaps[i].handle);
		if (__unlikely(h < 0)) {
			UNLOCK_MMAP;
			r = h;
			goto cls;
		}
		array[n_array++] = h;
	}
	UNLOCK_MMAP;
	r = 0;
	for (i = 0; i < n_array; i++) {
		IOCTLRQ io;
		io.h = array[i];
		io.ioctl = IOCTL_FSYNC;
		io.param = PARAM_FSYNC_ONLY_DATA | (flags & MS_ASYNC ? PARAM_FSYNC_ASYNC : 0);
		io.v.ptr = 0;
		io.v.len = 0;
		io.v.vspace = &KERNEL$VIRTUAL;
		SYNC_IO_CANCELABLE(&io, KERNEL$IOCTL);
		if (__unlikely(io.status < 0) && __likely(!r)) r = io.status;
	}
	cls:
	for (i = 0; i < n_array; i++) KERNEL$FAST_CLOSE(array[i]);
	if (__unlikely(r)) {
		errno = -r;
		return -1;
	}
	return 0;
}

__COLD_ATTR__ int _merror(void *start, size_t length)
{
	int i, r;
	int spl;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), KERNEL$SPL)))
		KERNEL$SUICIDE("_merror AT SPL %08X", KERNEL$SPL);
	if (__unlikely(!length)) return 0;
	length += ((unsigned long)start & (PAGE_CLUSTER_SIZE - 1));
	start = (void *)((unsigned long)start & ~(unsigned long)(PAGE_CLUSTER_SIZE - 1));
	length = (length + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);

	LOCK_MMAP;
	for (i = 0; i < udata.n_vmmaps; i++) {
		if (__likely((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize <= (char *)start)) continue;
		if ((char *)udata.vmmaps[i].vmaddr >= (char *)start + length) break;
		if (__unlikely(udata.vmmaps[i].error)) {
			r = udata.vmmaps[i].error;
			goto unlock_ret_r;
		}
	}
	r = 0;
	unlock_ret_r:
	UNLOCK_MMAP;
	return r;
}


__COLD_ATTR__ int UVM_SAVE_FAULT(void *a, int err)
{
	int i;
	for (i = 0; i < udata.n_vmmaps; i++) {
		if (__likely((char *)udata.vmmaps[i].vmaddr + udata.vmmaps[i].vmsize <= (char *)a)) continue;
		if (__unlikely((char *)a < (char *)udata.vmmaps[i].vmaddr)) return 0;
		goto brk;
	}
	return 0;
	brk:
	if (__likely(udata.vmmaps[i].flags & _MAP_NOFAULT)) {
		udata.vmmaps[i].flags = PROT_READ | PROT_WRITE | PROT_EXEC | __PROT_WRITTEN | MAP_PRIVATE | MAP_ANONYMOUS;
		__barrier();
		if (__likely(err < 0) && __likely((short)err == err)) udata.vmmaps[i].error = err;
		return 1;
	}
	return -1;
}

void KERNEL$FREE_KERNEL_PAGE(void *page, int type)
{
	munmap(page, PAGE_CLUSTER_SIZE);
}

void *KERNEL$ALLOC_KERNEL_PAGE(int type)
{
	void *page = mmap(NULL, PAGE_CLUSTER_SIZE, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
	if (__unlikely(!page)) {
		munmap(page, PAGE_CLUSTER_SIZE);
	}
	if (__unlikely(page == MAP_FAILED)) page = NULL;
	return page;
}

__COLD_ATTR__ PAGE *KERNEL$ALLOC_IO_PAGE(int type)
{
	void *p;
	if (__unlikely(!USER_PAGE_DESCS)) if (__unlikely(MAKE_USER_PAGES())) return NULL;
	p = KERNEL$ALLOC_KERNEL_PAGE(type);
	return KERNEL$PHYS_2_PAGE((unsigned long)p);
}

__COLD_ATTR__ PAGE *KERNEL$ALLOC_USER_PAGE(int type)
{
	return KERNEL$ALLOC_IO_PAGE(type);
}

__COLD_ATTR__ void KERNEL$FREE_USER_PAGE(PAGE *p, int type)
{
	KERNEL$FREE_KERNEL_PAGE((void *)(unsigned long)KERNEL$PAGE_2_PHYS(p), type);
}

__COLD_ATTR__ void KERNEL_TRANSFER_VM_STATE(int type_from, int type_to)
{
}

__COLD_ATTR__ static void VIRTUAL_UNMAP(void *ptr)
{
}

__COLD_ATTR__ static void VIRTUAL_UNLOCK(__u32 ptr)
{
}

__COLD_ATTR__ static void VIRTUAL_64UNLOCK(__u64 ptr)
{
}

__COLD_ATTR__ static void VIRTUAL_PHYSUNLOCK(__p_addr ptr)
{
}

__COLD_ATTR__ void *VIRTUAL_MAP(VDESC *desc, int rw, int spl, vspace_unmap_t **unmap)
{
	LOWER_SPLX(spl);
	*unmap = VIRTUAL_UNMAP;
	return (void *)(unsigned long)desc->ptr;
}

__COLD_ATTR__ vspace_dmaunlock_t *VIRTUAL_DMALOCK(VDESC *desc, int rw, VDMA *dma)
{
	LOWER_SPLX(dma->spl);
	dma->ptr = desc->ptr;
	dma->len = desc->len;
	return VIRTUAL_UNLOCK;
}

__COLD_ATTR__ vspace_dma64unlock_t *VIRTUAL_DMA64LOCK(VDESC *desc, int rw, VDMA64 *dma)
{
	LOWER_SPLX(dma->spl);
	dma->ptr = (unsigned long)desc->ptr;
	dma->len = desc->len;
	return VIRTUAL_64UNLOCK;
}

__COLD_ATTR__ vspace_physunlock_t *VIRTUAL_PHYSLOCK(VDESC *desc, int rw, VPHYS *dma)
{
	LOWER_SPLX(dma->spl);
	dma->ptr = (unsigned long)desc->ptr;
	dma->len = desc->len;
	return VIRTUAL_PHYSUNLOCK;
}

__COLD_ATTR__ void *KERNEL$MAP_PHYSICAL_BANK(__p_addr physaddr)
{
	return (void *)(unsigned long)physaddr;
}

__COLD_ATTR__ void KERNEL$UNMAP_PHYSICAL_BANK(void *ptr)
{
}

__COLD_ATTR__ __p_addr KERNEL$UNMAP_PHYSICAL_BANK_ADDR(void *ptr)
{
	return (unsigned long)ptr;
}

__COLD_ATTR__ PAGE *KERNEL$UNMAP_PHYSICAL_BANK_PAGE(void *ptr)
{
	return KERNEL$PHYS_2_PAGE((unsigned long)ptr);
}

__COLD_ATTR__ void *KERNEL$MAP_PHYSICAL_PAGE(PAGE *p)
{
	return (void *)(unsigned long)KERNEL$PAGE_2_PHYS(p);
}

__COLD_ATTR__ void *KERNEL$MAP_PHYSICAL_REGION_LONG_TERM(__p_addr physaddr, unsigned length, int pat)
{
	return (void *)(unsigned long)physaddr;
}

__COLD_ATTR__ void KERNEL$UNMAP_PHYSICAL_REGION_LONG_TERM(const void *vaddr, unsigned length)
{
}

__COLD_ATTR__ __p_addr KERNEL$PAGE_2_PHYS(PAGE *p)
{
	return (unsigned long)(p - USER_PAGE_DESCS) * PAGE_CLUSTER_SIZE;
}

__COLD_ATTR__ PAGE *KERNEL$PHYS_2_PAGE(__p_addr p)
{
	return &USER_PAGE_DESCS[(unsigned long)p / PAGE_CLUSTER_SIZE];
}

__COLD_ATTR__ unsigned long KERNEL$VIRT_2_PHYS(void *virt)
{
	return (unsigned long)virt;
}

__COLD_ATTR__ void *KERNEL$PHYS_2_VIRT(unsigned long phys)
{
	return (void *)phys;
}

__COLD_ATTR__ void *KERNEL$DMA_2_VIRT(unsigned long dma)
{
	return (void *)dma;
}

__COLD_ATTR__ __p_addr KERNEL$PHYSICAL_UNMAP_DMA(__u32 dma)
{
	return dma;
}

__COLD_ATTR__ __p_addr KERNEL$PHYSICAL_UNMAP_DMA64(__u64 dma)
{
	return dma;
}

__COLD_ATTR__ void KERNEL$NULL_VSPACE_UNMAP(void *ptr)
{
}

__COLD_ATTR__ void KERNEL$NULL_VSPACE_DMAUNLOCK(__u32 ptr)
{
}

__COLD_ATTR__ void KERNEL$NULL_VSPACE_DMA64UNLOCK(__u64 ptr)
{
}

__COLD_ATTR__ void KERNEL$NULL_VSPACE_PHYSUNLOCK(__p_addr ptr)
{
}

__COLD_ATTR__ DECL_IOCALL(KERNEL$WAKE_PAGE_RELEASE, SPL_TOP, PAGE_RELEASE_REQUEST)
{
	KERNEL$SUICIDE("KERNEL$WAKE_PAGE_RELEASE CALLED WITHOUT RELEASE REQUEST");
	RETURN;
}

__COLD_ATTR__ int KERNEL$OOM(int type)
{
	return 1;
}

__COLD_ATTR__ int KERNEL$OOM_ERR(size_t sz)
{
	return -ENOMEM;
}

__COLD_ATTR__ unsigned long KERNEL$VM_OOMKILL(void)
{
	return 0;
}

__COLD_ATTR__ int KERNEL$SET_MEMORY_LIMIT(__u64 mem, __u64 *h, int n_h)
{
	return -EUSER;
}

__COLD_ATTR__ int KERNEL$SET_MAPPED_MEMORY(__p_addr addr, __p_addr len, int pat)
{
	return -EUSER;
}

__COLD_ATTR__ int KERNEL$SET_MEMORY_PAT(__p_addr addr, __p_addr len, int pat)
{
	if (__unlikely(pat < 0) || __likely(pat == PAT_WB)) return 0;
	return -EUSER;
}

void *MAKE_USER_SIZES(size_t size)
{
	void *p;
#if __DEBUG >= 1
	if (__unlikely(KERNEL$SPL != SPL_X(SPL_MALLOC)))
		KERNEL$SUICIDE("MAKE_USER_SIZES AT SPL %08X", KERNEL$SPL);
#endif
	p = mmap(NULL, ((VMSPACE / PAGE_CLUSTER_SIZE * sizeof(USER_SIZE_DESC) + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1)) + size, PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS | _MAP_IMMEDIATE, -1, 0);
	if (__unlikely(__IS_ERR(p))) return p;
	USER_SIZE_DESCS = p;
	return (char *)p + ((VMSPACE / PAGE_CLUSTER_SIZE * sizeof(USER_SIZE_DESC) + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1));
}

int MAKE_USER_PAGES(void)
{
	int spl = KERNEL$SPL;
	if (__unlikely(SPLX_BELOW(SPL_X(SPL_MALLOC), spl)))
		KERNEL$SUICIDE("MAKE_USER_PAGES AT SPL %08X", spl);
	RAISE_SPL(SPL_MALLOC);
	if (__likely(!USER_PAGE_DESCS)) {
		void *p = mmap(NULL, VMSPACE / PAGE_CLUSTER_SIZE * sizeof(PAGE), PROT_READ | PROT_WRITE, MAP_PRIVATE | MAP_ANONYMOUS, -1, 0);
		if (__unlikely(p == MAP_FAILED)) {
			LOWER_SPLX(spl);
			return -ENOMEM;
		}
		USER_PAGE_DESCS = p;
	}
	LOWER_SPLX(spl);
	return 0;
}

__COLD_ATTR__ void *KERNEL$ALLOC_CONTIG_AREA(unsigned long size, int flags, ...)
{
	int e;
	void *p;
	unsigned long align = 1;
	va_list va;

	va_start(va, flags);

	if (flags & AREA_ALIGN) align = va_arg(va, unsigned long);
	if (__unlikely(!align) || __unlikely((align & (align - 1)) != 0))
		KERNEL$SUICIDE("KERNEL$ALLOC_CONTIG_AREA: INVALID ALIGN %lX", align);

	if (flags & AREA_NODE) va_arg(va, __node_id_t);

	va_end(va);

	if (__unlikely(!USER_PAGE_DESCS)) if (MAKE_USER_PAGES()) goto enomem;
	e = errno;
	p = memalign(align, size);
	errno = e;
	if (__unlikely(!p)) {
		enomem:
		return __ERR_PTR(-ENOMEM);
	}
	return p;
}

__COLD_ATTR__ void KERNEL$FREE_CONTIG_AREA(void *ptr, unsigned long size)
{
#if __DEBUG >= 2
	if (__unlikely(__alloc_size(ptr) < size))
		KERNEL$SUICIDE("KERNEL$FREE_CONTIG_AREA: INVALID SIZE: %lu < %lu", (unsigned long)__alloc_size(ptr), size);
#endif
	free(ptr);
}

DECL_IOCALL(KERNEL$UNIVERSAL_MALLOC, SPL_MALLOC, MALLOC_REQUEST)
{
	if (__likely((RQ->ptr = malloc(RQ->size)) != NULL)) {
		RQ->status = 0;
		RETURN_AST(RQ);
	}
	RQ->status = -ENOMEM;
	RETURN_AST(RQ);
}

__COLD_ATTR__ void KERNEL$MEMWAIT(IORQ *rq, IO_STUB *fn, size_t sz)
{
	rq->status = -ENOMEM;
	CALL_AST(rq);
}

__COLD_ATTR__ int KERNEL$MEMWAIT_SYNC(size_t sz)
{
	errno = ENOMEM;
	return -ENOMEM;
}

__COLD_ATTR__ WQ *KERNEL$VM_UNMAP_PAGE(PAGE *p)
{
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely(p->flags & (PAGE_BUSY | PAGE_DMALOCKCOUNT | PAGE_WRITECOUNT)))
		return &p->wait;
	return NULL;
}

__COLD_ATTR__ WQ *KERNEL$VM_UNSET_WRITEABLE(PAGE *p)
{
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely(p->flags & (PAGE_BUSY | PAGE_DMALOCKCOUNT)))
		return &p->wait;
	return NULL;
}

__COLD_ATTR__ int KERNEL$VM_SCAN_PAGE(PAGE *p)
{
	return 0;
}

__COLD_ATTR__ WQ *KERNEL$VM_UNMAP_SPAGE(SPAGE *sp)
{
	RAISE_SPL(SPL_VSPACE);
	if (__unlikely(sp->flags & (PAGE_BUSY | PAGE_DMALOCKCOUNT | PAGE_WRITECOUNT)))
		return &sp->wait;
	return NULL;
}

__COLD_ATTR__ int KERNEL$VM_SCAN_SPAGE(SPAGE *sp)
{
	return 0;
}

__COLD_ATTR__ void KERNEL$VM_PREPARE_PAGE_FOR_MMAP(PAGE *p)
{
}

__COLD_ATTR__ __u64 KERNEL$GET_MEMORY_SIZE(int type)
{
	/* !!! FIXME: query swapper */
	return VMSPACE;
}

static char *break_start = NULL;
static size_t break_total = 0;
static size_t break_current = 0;

__COLD_ATTR__ static int init_brk(void)
{
	void *p;
	size_t s = (1 << __BSR_CONST(VMSPACE / 2)) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
	again:
	p = mmap(NULL, s, PROT_NONE, MAP_ANONYMOUS | MAP_PRIVATE, -1, 0);
	if (__unlikely(p == MAP_FAILED)) {
		s = (s >> 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
		if (__likely(s != 0)) goto again;
		errno = ENOMEM;
		return -1;
	}
	break_start = p;
	break_total = s;
	break_current = 0;
	return 0;
}

__COLD_ATTR__ int brk(void *end)
{
	if (__unlikely(!break_start)) if (__unlikely(init_brk())) return -1;
	return sbrk((char *)end - (break_start + break_current)) ? 0 : -1;
}

__COLD_ATTR__ void *sbrk(ssize_t inc)
{
	size_t nbc, bca, nbca;
	size_t obc;
	if (__unlikely(!break_start)) if (__unlikely(init_brk())) return NULL;
	nbc = break_current + inc;
	if (__unlikely(nbc > break_total)) {
		errno = inc >= 0 ? ENOMEM : EINVAL;
		return NULL;
	}
	bca = (break_current + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
	nbca = (nbc + PAGE_CLUSTER_SIZE - 1) & ~(size_t)(PAGE_CLUSTER_SIZE - 1);
	if (nbca > bca) {
		if (__unlikely(mprotect(break_start + bca, nbca - bca, PROT_READ | PROT_WRITE))) return NULL;
	} else if (nbca < bca) {
		mmap(break_start + nbca, bca - nbca, PROT_NONE, MAP_ANONYMOUS | MAP_PRIVATE | MAP_FIXED, -1, 0);
	}
	obc = break_current;
	break_current = nbc;
	return break_start + obc;
}

__COLD_ATTR__ void VM_CHECK_MAGICS(void)
{
}
