#include <SYS/PARAM.H>
#include <ERRNO.H>
#include <STRING.H>
#include <SYS/TYPES.H>
#include <STDLIB.H>

#include <LIBGEN.H>

char *basename(const char *name)
{
	const char *e, *d;
	static char *bname = NULL;
	if (__unlikely(!name) || __unlikely(!*name)) return ".";
	e = name + strlen(name) - 1;
	while (__unlikely(*e == '/')) {
		e--;
		if (e < name) return "/";
	}
	d = e;
	while (__likely(*d != '/') && __likely(*d != ':') && __likely(d >= name)) d--;
	d++;
	e++;
	if (__unlikely(d == e)) return "/";
	if (__unlikely(e - d + 1 > __alloc_size(bname))) {
		if (__unlikely(!(bname = reallocf(bname, e - d + 1))))
			return NULL;
	}
	memcpy(bname, d, e - d);
	bname[e - d] = 0;
	return bname;
}
