#include <SPAD/DEV.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <UNISTD.H>
#include <VALUES.H>
#include <PATHS.H>

#include <STDLIB.H>

static char *const inithandles[3] = { _LNM_STDIN, _LNM_STDOUT, _LNM_STDERR };

int daemon(int nochdir, int noclose)
{
	if (__unlikely(!FEATURE_TEST(FEATURE_USERSPACE))) return 0;
	if (__likely(!nochdir)) chdir("HOME:/"), chdir("/");
	if (__likely(!noclose)) {
		int i;
		for (i = 0; i < 2; i++) {
			KERNEL$CREATE_LOGICAL(inithandles[i], _PATH_DEVNULL, LNTE_PUBLIC | LNTE_FILE_SHARE);
		}
	}
	_background(NULL);
	return 0;
}
