#include <SYS/PARAM.H>
#include <ERRNO.H>
#include <STRING.H>
#include <SYS/TYPES.H>
#include <STDLIB.H>

#include <LIBGEN.H>

char *dirname(const char *name)
{
	const char *e;
	static char *bname = NULL;
	if (__unlikely(!name) || __unlikely(!*name)) return ".";
	e = name + strlen(name) - 1;
	while (__unlikely(*e == '/')) {
		e--;
		if (e < name) return "/";
	}
	while (__likely(*e != '/') && __likely(*e != ':') && __likely(e >= name)) e--;
	if (__unlikely(e <= name)) {
		if (__likely(e < name)) return ".";
		return "/";
	}
	if (__unlikely(*e == ':')) {
		e++;
		if (*e == '/') e++;
	} else if (e[-1] == ':') e++;
	if (__unlikely(e - name + 1 > __alloc_size(bname))) {
		if (__unlikely(!(bname = reallocf(bname, e - name + 1))))
			return NULL;
	}
	memcpy(bname, name, e - name);
	bname[e - name] = 0;
	return bname;
}
