#include <STDIO.H>
#include <STDLIB.H>
#include <STRING.H>
#include <ERRNO.H>
#include <STDARG.H>

#include <ERROR.H>

extern const char *__progname;

void (*error_print_progname) (void) = NULL;
unsigned int error_message_count = 0;
int error_one_per_line = 0;

void error(int status, int errnum, const char *format, ...)
{
	va_list ap;
	if (error_print_progname) error_print_progname();
	else fprintf(stderr, "%s: ", __progname);
	va_start(ap, format);
	vfprintf(stderr, format, ap);
	if (errnum) fprintf(stderr, ": %s\n", strerror(errnum));
	else fprintf(stderr, "\n");
	fflush(stderr);
	error_message_count++;
	if (status) exit(status);
}

void error_at_line(int status, int errnum, const char *fname, unsigned int lineno, const char *format, ...)
{
	va_list ap;
	if (error_one_per_line) {
		static const char *old_fname = "";
		static unsigned int old_lineno = 0;
		if (old_lineno == lineno && !strcasecmp(old_fname, fname)) return;
		old_fname = fname;
		old_lineno = lineno;
	}
	if (error_print_progname) error_print_progname();
	else fprintf(stderr, "%s: %s:%d: ", __progname, fname, lineno);
	va_start(ap, format);
	vfprintf(stderr, format, ap);
	if (errnum) fprintf(stderr, ": %s\n", strerror(errnum));
	else fprintf(stderr, "\n");
	fflush(stderr);
	error_message_count++;
	if (status) exit(status);
}
