#include <SYS/UTSNAME.H>
#include <SYS/TYPES.H>
#include <STRING.H>
#include <ERRNO.H>

#include <UNISTD.H>

int getdomainname(char *name, size_t len)
{
	struct utsname buf;
	if (__unlikely(uname(&buf))) return -1;
	if (__unlikely(strlen(buf.domainname) + 1 > len)) {
		errno = ERANGE;
		return -1;
	}
	strcpy(name, buf.domainname);
	return 0;
}
