#include <STRING.H>
#include <UNISTD.H>
#include <STDLIB.H>

#include <GRP.H>

static char *mem2[] = { "user", NULL };
static struct group g2 = { "user", "", 1, (char **)mem2 };

static char *mem[] = { "root", NULL };
static struct group g = { "root", "", 0, (char **)mem };

static void fillgrp(void)
{
	char *s;
	if (__unlikely(!(s = getenv("USER")))) s = "USER";
	mem2[0] = s;
	g2.gr_name = s;
	g2.gr_gid = getgid();
}

static int grentry = 0;

struct group *getgrent(void)
{
	if (!grentry) {
		grentry++;
		fillgrp();
		return (struct group *)&g2;
	}
	if (grentry == 1) {
		grentry++;
		return (struct group *)&g;
	}
	return NULL;
}

struct group *getgrnam(const char *name)
{
	fillgrp();
	if (!strcasecmp(name, g2.gr_name)) return (struct group *)&g2;
	if (!strcasecmp(name, g.gr_name)) return (struct group *)&g;
	return NULL;
}

struct group *getgrgid(gid_t gid)
{
	fillgrp();
	if (gid == g2.gr_gid) return (struct group *)&g2;
	if (gid == g.gr_gid) return (struct group *)&g;
	return NULL;
}

int setgrent(void)
{
	grentry = 0;
	return 1;
}

void endgrent(void)
{
	grentry = 0;
}

int setgroupent(int stayopen)
{
	grentry = 0;
	return 1;
}

int initgroups(const char *user, gid_t group)
{
	return 0;
}
