#include <STDLIB.H>
#include <ERRNO.H>

#include <STDIO.H>
#include <UNISTD.H>
#include <STRING.H>

char *getlogin(void)
{
	return getenv("USER");
}

int getlogin_r(char *str, int len)
{
	char *l = getlogin();
	if (__unlikely(strlen(l) + 1 > len)) {
		return ERANGE;
	}
	strcpy(str, l);
	return 0;
}

char *cuserid(char *string)
{
	if (!string) {
		return getlogin();
	} else {
		int r = getlogin_r(string, L_cuserid);
		if (__unlikely(r)) {
			errno = r;
			return NULL;
		}
		return string;
	}
}
