#include <STRING.H>
#include <ERRNO.H>
#include <SPAD/DL.H>
#include <SPAD/SYNC.H>
#include <SPAD/CHARSET.H>

#include <ICONV.H>

static char iconv_loaded = 0;

static iconv_t iconv_load_open(const char *to, const char *from);

iconv_t iconv_open(const char *to, const char *from)
{
	iconv_t ic;
	if (__unlikely(!iconv_loaded)) return iconv_load_open(to, from);
	ic = CHARSET$ICONV_OPEN(to, from, ICONV_ATTR_LEAVE_AT_UNLOAD);
	if (__unlikely(!ic)) ic = (iconv_t)-1;
	return ic;
}

int iconv_close(iconv_t ic)
{
	if (__unlikely(ic == (iconv_t)-1)) return 0;
	CHARSET$ICONV_CLOSE(ic);
	return 0;
}

size_t iconv(iconv_t ic, char **inbuf, size_t *inlen, char **outbuf, size_t *outlen)
{
	return CHARSET$ICONV(ic, inbuf, inlen, outbuf, outlen);
}

static iconv_t iconv_load_open(const char *to, const char *from)
{
	DLLZRQ lz;
	lz.handle = NULL;
	lz.caller = iconv_load_open;
	strcpy(lz.modname, "CHARSET");
	SYNC_IO(&lz, KERNEL$DL_LOAD_LAZY);
	if (__unlikely(lz.status < 0)) {
		errno = -lz.status;
		return (iconv_t)-1;
	}
	iconv_loaded = 1;
	return iconv_open(to, from);
}
