#include <STDIO.H>
#include <ERRNO.H>
#include <SPAD/DEV.H>
#include <SPAD/LIBC.H>
#include <SPAD/SYNC.H>
#include <SYS/STATFS.H>
#include <STDLIB.H>
#include <STRING.H>

#include <MNTENT.H>

static char **namelist = NULL;
static int active;

static void release_namelist(void)
{
	int i;
	if (__unlikely(!namelist)) return;
	for (i = 0; namelist[i]; i++) free(namelist[i]);
	free(namelist);
	namelist = NULL;
}

FILE *setmntent(const char *file, const char *mode)
{
	release_namelist();
	return stderr;
}

static struct mntent mntent;
static struct statfs st;
static char name[__MAX_STR_LEN];

struct mntent *getmntent(FILE *stream)
{
	LOGICAL_LIST_REQUEST llr;
	if (__unlikely(!namelist)) {
		int i;
		llr.prefix = "";
		SYNC_IO(&llr, KERNEL$LIST_LOGICALS);
		if (__unlikely(llr.status < 0)) {
			return NULL;
		}
		if (__unlikely(!(namelist = calloc(llr.n_entries + 1, sizeof(char *))))) {
			KERNEL$FREE_LOGICAL_LIST(&llr);
			return NULL;
		}
		for (i = 0; i < llr.n_entries; i++) {
			if (__unlikely(!(namelist[i] = strdup(llr.entries[i]->name)))) {
				release_namelist();
				KERNEL$FREE_LOGICAL_LIST(&llr);
				return NULL;
			}
		}
		KERNEL$FREE_LOGICAL_LIST(&llr);
		active = 0;
	}
	next:
	if (__unlikely(!namelist[active])) return NULL;
	_snprintf(name, __MAX_STR_LEN, "%s:/", namelist[active++]);
	if (statfs(name, &st)) goto next;
	mntent.mnt_fsname = st.f_fsmntfromname;
	mntent.mnt_dir = name;
	mntent.mnt_type = st.f_fstypename;
	mntent.mnt_opts = "rw";
	mntent.mnt_freq = 0;
	mntent.mnt_passno = 0;
	return &mntent;
}

int addmntent(FILE *stream, const struct mntent *mnt)
{
	errno = ENOSYS;
	return 1;
}

int endmntent(FILE *stream)
{
	release_namelist();
	return 1;
}

char *hasmntopt(const struct mntent *mnt, const char *opt)
{
	return NULL;
}
