#include <SYS/TYPES.H>
#include <SIGNAL.H>
#include <STRING.H>
#include <UNISTD.H>

void psignal(int signum, const char *s)
{
	const char *n;
	if (s && *s) {
		write(STDERR_FILENO, s, strlen(s));
		write(STDERR_FILENO, ": ", 2);
	}
	n = strsignal(signum);
	write(STDERR_FILENO, n, strlen(n));
	write(STDERR_FILENO, "\n", 1);
}

